/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.synredis.util;

import com.duiba.synredis.util.PropertyUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtil {
    private static final Logger logger = LoggerFactory.getLogger(HiveUtil.class);
    private String driverName;
    private String url;
    private String username;
    private String pwd;
    private Connection conn = null;

    public HiveUtil() {
        PropertyUtil instance = PropertyUtil.getInstance();
        if (null != instance) {
            this.driverName = instance.getProperty("hive.drivername");
            this.url = instance.getProperty("hive.url");
            this.username = instance.getProperty("hive.username");
            this.pwd = instance.getProperty("hive.password");
        }
    }

    public Connection getConnnection() {
        try {
            Class.forName(this.driverName);
            this.conn = DriverManager.getConnection(this.url, this.username, this.pwd);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SQLException e) {
            logger.error("getConnection error" + e.getMessage());
            e.printStackTrace();
        }
        return this.conn;
    }

    public static PreparedStatement prepare(Connection conn, String sql) {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getMapData(String sql) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == this.conn) {
            this.conn = this.getConnnection();
        }
        PreparedStatement ps = HiveUtil.prepare(this.conn, sql);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            while (rs.next()) {
                String advertId = rs.getString(1);
                String new_trade = rs.getString(2);
                map.put(advertId, new_trade);
            }
        }
        catch (Exception e) {
            logger.error("getMapData error is " + e);
        }
        finally {
            try {
                rs.close();
                ps.close();
                this.conn.close();
            }
            catch (Exception exception) {}
        }
        return map;
    }

    public static void main(String[] args) {
        HiveUtil util = new HiveUtil();
        Connection conn = util.getConnnection();
        String sql = "select advert_id,new_trade from advert.dws_advert_newtrade_df limit 100";
        System.out.print(util.getMapData(sql));
    }
}

