/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.synredis.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtil.class);
    private static volatile PropertyUtil instance = null;
    private Properties props = new Properties();
    private static final String fileName = "application.properties";

    private PropertyUtil() {
        InputStream in = null;
        try {
            in = PropertyUtil.class.getClassLoader().getResourceAsStream(fileName);
            this.props.load(in);
        }
        catch (Exception e) {
            logger.error("PropertyUtil init error.", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error("close file InputStream error.", (Throwable)e);
            }
        }
    }

    public static PropertyUtil getInstance() {
        if (instance == null) {
            PropertyUtil.init();
        }
        return instance;
    }

    private static synchronized void init() {
        if (instance == null) {
            instance = new PropertyUtil();
        }
    }

    public String getProperty(String key) {
        if (this.props == null) {
            PropertyUtil.init();
        }
        return this.props.getProperty(key);
    }

    public int getPropertyForInt(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public long getPropertyForLong(String key) {
        return Long.parseLong(this.getProperty(key));
    }

    public boolean getPropertyForBoolean(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }
}

