package com.duiba.synredis.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;
import java.util.HashMap;
import java.util.Map;

public class HiveUtil {
    private static final Logger logger = LoggerFactory.getLogger(HiveUtil.class);
    private String driverName;
    private String url;
    private String username;
    private String pwd;
    private Connection conn = null;

    public HiveUtil() {
        //加载配置文件
        PropertyUtil instance = PropertyUtil.getInstance();
        if (null != instance) {
            driverName = instance.getProperty("hive.drivername");
            url = instance.getProperty("hive.url");
            username = instance.getProperty("hive.username");
            pwd = instance.getProperty("hive.password");
        }
    }

    public Connection getConnnection() {
        try {
            Class.forName(driverName);
            conn = DriverManager.getConnection(url, username, pwd);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        } catch (SQLException e) {
            logger.error("getConnection error" + e.getMessage());
            e.printStackTrace();
        }
        return conn;
    }

    public static PreparedStatement prepare(Connection conn, String sql) {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
        } catch (SQLException e) {

            e.printStackTrace();
        }
        return ps;
    }


    public Map<String, String> getMapData(String sql) {
        Map<String, String> map = new HashMap<>();
        Connection connection = getConnnection();
        PreparedStatement ps = prepare(connection, sql);
        ResultSet rs =null;
        try {
             rs = ps.executeQuery();
            int columns = rs.getMetaData().getColumnCount();
            for (int i = 0; i < columns; i++) {
                String colName = rs.getMetaData().getColumnName(i);
                String colVal = rs.getString(i);
                map.put(colName, colVal);
            }

        } catch (Exception e){
           logger.error("getMapData error is "+e.getMessage());
        } finally {
            try {
                rs.close();
                ps.close();
                connection.close();
            }
            catch (Exception e){
            }
        }
        return map;
    }


}
