package com.duiba.synredis.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtil.class);
    //volatile 禁止jvm进行指令重排
    private volatile static PropertyUtil instance = null;
    private Properties props;
    private static final String fileName = "application.properties";

    private PropertyUtil(){
        props = new Properties();
        InputStream in = null;
        try {
            in = PropertyUtil.class.getClassLoader().getResourceAsStream(fileName);
            props.load(in);
        } catch (Exception e){
            logger.error("PropertyUtil init error.", e);
        } finally {
            try {
                if(in != null) {
                    in.close();
                }
            } catch (IOException e) {
                logger.error("close file InputStream error.", e);
            }
        }
    }

    public static PropertyUtil getInstance(){
        if(instance == null){
            init();
        }
        return instance;
    }

    private synchronized static void init(){
        if(instance == null){
            instance = new PropertyUtil();
        }
    }

    public String getProperty(String key){
        if(props == null) {
            init();
        }
        return props.getProperty(key);
    }

    public int getPropertyForInt(String key){
        return Integer.parseInt(getProperty(key));
    }

    public long getPropertyForLong(String key){
        return Long.parseLong(getProperty(key));
    }

    public boolean getPropertyForBoolean(String key){
        return Boolean.parseBoolean(getProperty(key));
    }
}
