package com.duiba.synredis.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;
import java.util.HashMap;
import java.util.Map;

public class HiveUtil {
    private static final Logger logger = LoggerFactory.getLogger(HiveUtil.class);
    private String driverName;
    private String url;
    private String username;
    private String pwd;
    private Connection conn = null;

    public HiveUtil() {
        //加载配置文件
        PropertyUtil instance = PropertyUtil.getInstance();
        if (null != instance) {
            driverName = instance.getProperty("hive.drivername");
            url = instance.getProperty("hive.url");
            username = instance.getProperty("hive.username");
            pwd = instance.getProperty("hive.password");
        }
    }

    public Connection getConnnection() {
        try {
            Class.forName(driverName);
            conn = DriverManager.getConnection(url, username, pwd);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        } catch (SQLException e) {
            logger.error("getConnection error" + e.getMessage());
            e.printStackTrace();
        }
        return conn;
    }

    public static PreparedStatement prepare(Connection conn, String sql) {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
        } catch (SQLException e) {

            e.printStackTrace();
        }
        return ps;
    }


    public Map<String, String> getMapData(String sql) {
        Map<String, String> map = new HashMap<>();
        if (null == conn) {
            conn = getConnnection();
        }
        PreparedStatement ps = prepare(conn, sql);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            while (rs.next()){
                String advertId = rs.getString(1);
                String new_trade = rs.getString(2);
                map.put(advertId, new_trade);
            }

        } catch (Exception e) {
            logger.error("getMapData error is " + e);
        } finally {
            try {
                rs.close();
                ps.close();
                conn.close();
            } catch (Exception e) {
            }
        }
        return map;
    }


    public static void main(String[] args) {
        HiveUtil util = new HiveUtil();
        Connection conn = util.getConnnection();
        String sql = "select advert_id,new_trade from advert.dws_advert_newtrade_df limit 100";
        System.out.print(util.getMapData(sql));
    }
}
