/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.synredis.util;

import com.duiba.synredis.util.PropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class HadoopRedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(HadoopRedisUtil.class);
    private static JedisPool jedisPool = null;
    private static volatile HadoopRedisUtil instance = null;

    private HadoopRedisUtil(int maxActive) {
        PropertyUtil instance = PropertyUtil.getInstance();
        if (maxActive == 0) {
            maxActive = instance.getPropertyForInt("redis.max_active");
        }
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(instance.getPropertyForInt("redis.max_idle"));
        config.setMinIdle(instance.getPropertyForInt("redis.min_idle"));
        config.setMaxWaitMillis(instance.getPropertyForLong("redis.max_wait"));
        config.setMaxTotal(maxActive);
        config.setTestOnBorrow(instance.getPropertyForBoolean("redis.test_on_borrow"));
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(instance.getPropertyForLong("redis.test_while_idle"));
        jedisPool = new JedisPool((GenericObjectPoolConfig)config, instance.getProperty("hadoop.redis.host"), instance.getPropertyForInt("redis.port"), instance.getPropertyForInt("redis.timeout"), instance.getProperty("hadoop.redis.auth"));
    }

    public static HadoopRedisUtil getInstance() {
        return HadoopRedisUtil.getInstance(0);
    }

    public static HadoopRedisUtil getInstance(int maxActive) {
        if (instance == null) {
            HadoopRedisUtil.init(maxActive);
        }
        return instance;
    }

    private static synchronized void init(int maxActive) {
        if (instance == null) {
            instance = new HadoopRedisUtil(maxActive);
        }
    }

    private Jedis getJedis() {
        return jedisPool.getResource();
    }

    private void returnResource(Jedis jedis) {
        try {
            if (jedis != null) {
                jedis.close();
            }
        }
        catch (Exception e) {
            logger.error("returnResource error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String fieid) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.hget(key, fieid);
            return string;
        }
        catch (Exception e) {
            logger.error("redis hget error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hset(String key, String field, String value) {
        Jedis jedis = this.getJedis();
        try {
            jedis.hset(key, field, value);
        }
        catch (Exception e) {
            logger.error("redis hmset error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hmset(String key, Map<String, String> map) {
        Jedis jedis = this.getJedis();
        try {
            jedis.hmset(key, map);
        }
        catch (Exception e) {
            logger.error("redis hmset error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        Jedis jedis = this.getJedis();
        try {
            Map map = jedis.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            logger.error("redis hgetAll error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hincrBy(String key, String field, Long value) {
        Jedis jedis = this.getJedis();
        try {
            jedis.hincrBy(key, field, value.longValue());
        }
        catch (Exception e) {
            logger.error("redis hincrBy error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hincrBy(String key, String field, Long value, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            jedis.hincrBy(key, field, value.longValue());
            jedis.expire(key, seconds);
        }
        catch (Exception e) {
            logger.error("redis hincrBy error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hincrBy(String key, Map<String, Long> map) {
        Jedis jedis = this.getJedis();
        try {
            Pipeline pipe = jedis.pipelined();
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                pipe.hincrBy(key, entry.getKey(), entry.getValue().longValue());
            }
            pipe.sync();
        }
        catch (Exception e) {
            logger.error("redis hincrBy error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hincrBy(String key, Map<String, Long> map, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            Pipeline pipe = jedis.pipelined();
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                pipe.hincrBy(key, entry.getKey(), entry.getValue().longValue());
            }
            pipe.expire(key, seconds);
            pipe.sync();
        }
        catch (Exception e) {
            logger.error("redis hincrBy error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hincrBy(List<String> redisKeyList, Map<String, Long> map) {
        Jedis jedis = this.getJedis();
        try {
            Pipeline pipe = jedis.pipelined();
            for (String redisKey : redisKeyList) {
                for (String column : map.keySet()) {
                    pipe.hincrBy(redisKey, column, map.get(column).longValue());
                }
            }
            pipe.sync();
        }
        catch (Exception e) {
            logger.error("redis hincrBy error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String key) {
        Jedis jedis = this.getJedis();
        try {
            Boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            logger.error("redis exists error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String key, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.expire(key, seconds);
            return l;
        }
        catch (Exception e) {
            logger.error("redis expire error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(List<String> redisKeyList, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            Pipeline pipe = jedis.pipelined();
            for (String redisKey : redisKeyList) {
                pipe.expire(redisKey, seconds);
            }
            pipe.sync();
        }
        catch (Exception e) {
            logger.error("redis expire error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeLineMset(Map<String, String> map, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            if (map != null && map.size() > 0) {
                Pipeline pipeline = jedis.pipelined();
                for (String key : map.keySet()) {
                    pipeline.setex(key, seconds, map.get(key));
                }
                pipeline.sync();
            }
        }
        catch (Exception e) {
            logger.error("redis pipeLineMset error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeLineDel(List<String> keyList) {
        Jedis jedis = this.getJedis();
        try {
            if (keyList != null && keyList.size() > 0) {
                Pipeline pipeline = jedis.pipelined();
                for (String key : keyList) {
                    pipeline.del(key);
                }
                pipeline.sync();
            }
        }
        catch (Exception e) {
            logger.error("redis pipeLineDel error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            logger.error("redis get error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, int expire) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.setex(key, expire, value);
            return string;
        }
        catch (Exception e) {
            logger.error("redis set error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.del(key);
            return l;
        }
        catch (Exception e) {
            logger.error("redis del error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> hmget(List<String> keyList) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        Jedis jedis = this.getJedis();
        try {
            Pipeline pipe = jedis.pipelined();
            HashMap<String, Response> tmpMap = new HashMap<String, Response>();
            for (String string : keyList) {
                tmpMap.put(string, pipe.hgetAll(string));
            }
            pipe.sync();
            for (Map.Entry entry : tmpMap.entrySet()) {
                resultMap.put((String)entry.getKey(), (Map<String, String>)((Response)entry.getValue()).get());
            }
        }
        catch (Exception e) {
            logger.error("redis hmget error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.set(key, value);
            return string;
        }
        catch (Exception e) {
            logger.error("redis get error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> pipeLineMget(List<String> keyList) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Jedis jedis = this.getJedis();
        try {
            Pipeline pipe = jedis.pipelined();
            HashMap<String, Response> tmpMap = new HashMap<String, Response>();
            for (String string : keyList) {
                tmpMap.put(string, pipe.get(string));
            }
            pipe.sync();
            for (Map.Entry entry : tmpMap.entrySet()) {
                resultMap.put((String)entry.getKey(), (String)((Response)entry.getValue()).get());
            }
        }
        catch (Exception e) {
            logger.error("redis pipeLineMget error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeLineHincrBy(String field, Map<String, Long> map, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            Pipeline pipe = jedis.pipelined();
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                String key = entry.getKey();
                pipe.hincrBy(key, field, entry.getValue().longValue());
                pipe.expire(key, seconds);
            }
            pipe.sync();
        }
        catch (Exception e) {
            logger.error("redis hincrBy error.", (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }
}

