/*
 * @Author: ygy
 * @Date: 2018-03-14 19:40:01
 * @Last Modified by: ygy
 * @Last Modified time: 2018-03-26 14:36:17
 */
const Koa = require('koa');
const send = require('koa-send');
const bodyParser = require('koa-bodyparser');
const path = require('path');

const router = require('./router');
const templating = require('./utils/templating');
const rest = require('./utils/rest');
const filter = require('./filter/index');
const task = require('./task/index');
const schedule = require('node-schedule');

const app = new Koa();

// log request URL:
app.use(async (ctx, next) => {
  console.log(`Process ${ctx.request.method} ${ctx.request.url}...`);
  await next();
});

if (process.env.NODE_ENV === 'production') {
  // chek user's login state,except index,login,signin pages
  app.use(filter.checkLogin);
}

// parse request body:
app.use(bodyParser());

// add nunjucks as view:
app.use(templating('views', {
  // in production ENV,noCache should be changed to false.
  noCache: true,
  watch: true
}));

app.use(async (ctx, next) => {
  if (ctx.path.indexOf('/dist') !== -1) {
    await send(ctx, ctx.path, {
      root: path.join(__dirname, 'static')
    });
  } else if (ctx.path === '/private') {
    await ctx.render('private.html');
  } else if (ctx.path === '/') {
    await ctx.render('index.html');
  } else {
    await next();
  }
});

// bind .rest() for ctx:
app.use(rest.restify());

// add controllers:
app.use(router());

// start task schedule
schedule.scheduleJob({ hour: 4, minute: 0, second: 0 }, () => {
  task.runTiming();
});

app.listen(5000);
console.log('Project is running at http://localhost:5000/');
