export default {
  setCookie(cname, cvalue, exdays) {
    const d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    const expires = 'expires=' + d.toUTCString();
    document.cookie = cname + '=' + cvalue + '; ' + expires;
  },
  getCookie(name) {
    const regexp = new RegExp('(^| )' + name + '=([^;]*)(;|$)');
    const matches = regexp.exec(document.cookie);
    return matches ? matches[2] : null;
  },
  clearCookie(name) {
    this.setCookie(name, '', -1);
  }
}
