const model = require('../config/model');

let User = model.User;

let findOneByUsername = async(username) => {
  let user = await User.findOne({
    where: {
      username
    }
  });
  return user;
}

let findOneById = async(uid) => {
  let user = await User.findOne({
    where: {
      id: uid
    }
  });
  return user;
}

let createUser = async(userObj={}) => {
  const {
    username,
    name,
    department,
    password
  } = userObj;
  let newUser = await User.create({
    username,
    name,
    department,
    password
  });
  return newUser;
}

module.exports = {
  findOneByUsername,
  findOneById,
  createUser
};
