// 回调地狱
module.exports = function (param, cb) {
  asyncFun1(param, function (result1) {
    asyncFun2(result1, function (result2) {
      asyncFun3(result2, function (result3) {
        cb(result3)
      })
    })
  })
};

// Promise
module.exports = function (param, cb) {
  asyncFun1(param).then(function (result1) {
      return result1;
    }
  ).then(function (result1) {
    return asyncFun2(param);
  }).then(function (result2) {
    return asyncFun3(param);
  }).then(function (result3) {
    cb(result3);
  });
}

// ES6 Generator
module.exports = function* (param, cb) {
  const result1 = yield asyncFun1(param);
  const result2 = yield asyncFun2(result1);
  const result3 = yield asyncFun3(result2);
  cb(result3);
};

// ES7
module.exports =  async(param, cb) => {
  const result1 = await asyncFun1(param);
  const result2 = await asyncFun2(result1);
  const result3 = await asyncFun3(result2);
  cb(result3);
};
