/*
 * @Author: ygy
 * @Date: 2018-03-14 19:39:46
 * @Last Modified by: ygy
 * @Last Modified time: 2018-03-23 14:00:53
 */

const historyService = require('../services/historyService');
const date = require('../utils/date');
const timing = require('./timing');

const runTiming = async () => {
  const urls = [
    {
      id: 'tuia',
      href: `http://activity.tuidragon.com/activity/index?id=5644&slotId=2380&login=normal&appKey=3p1fqtfC3x5krVrsgCmdSx68JPPj&deviceId=b17b1d5e-7dba-4a55-bedb-26ff10bec388&dsm=1.2380.0.0&tenter=SOW&tck_rid_6c8=0a1b5a39jat135tf-6340031&tck_loc_c5d=tactivity-4783&dcm=401.2380.0.0&&tenter=SOW&tck_userId_674=null`,
      arr: []
    }
  ];

  await timing.iterateTimes(urls, 2);
  const resultToSave = urls[0]['arr'];

  const total = resultToSave.reduce((item, index) => {
    console.log(item, index);
    return item + index;
  });

  await historyService.createOne({
    result: JSON.stringify({ all: total / (resultToSave.length || 1) }),
    owner: 'test',
    type: '大转盘1',
    day: date.dateFormat(new Date(), 'yyyy-MM-dd')
  });
};

module.exports = {
  runTiming
};
