let path = require('path');
var fs = require('fs');
let router = require('express').Router();

let routerMap = JSON.parse(fs.readFileSync(path.join(__dirname, './router-map.json')));

const handleHttp = (url) => {
  return [url, (req, res) => {
    let filePath = path.join(__dirname, '../data/', `${routerMap[url]}.json`)
    res.json(JSON.parse(fs.readFileSync(filePath)))
  }];
};

for (let url in routerMap) {
  router.get(...handleHttp(url));
  router.post(...handleHttp(url));
}

console.log(router)
module.exports = router;
