const express = require('express');
const path = require('path');

const webpack = require('webpack');
const webpackDevMiddleware = require('webpack-dev-middleware');
const webpackHotMiddleware = require('webpack-hot-middleware');

const devConfig = require('./build/webpack.dev.config.js');
const compiler = webpack(devConfig);

const app = express();

app.use(webpackDevMiddleware(compiler, {
  publicPath: devConfig.output.publicPath,
  stats: {
    colors: true,
    chunks: false
  }
}));

app.use(webpackHotMiddleware(compiler));

app.use(express.static('./'));

app.set('view engine', 'html');
app.set('views', path.join(__dirname, './html'));
app.engine('.html', require('ejs').__express);

app.get('/', function(req, res) {
  res.render('index');
});

app.use('/private', function(req, res) {
  res.render(path.join(__dirname, './private.html'));
});

app.use(require('./mock/router/router'));

console.log(`<http://localhost:8086> with Chrome`);

module.exports = app;
