
const puppeteer = require('puppeteer');
const devices = require('puppeteer/DeviceDescriptors');
const iPhone = devices['iPhone 6'];

/**
 * 启用无头浏览器，根据列表里的页面地址去循环执行
 */
const runBrowser = async (urls) => {
  const browser = await puppeteer.launch();

  const requests = [];
  for (const url of urls) {
    requests.push(await runPage(browser, url));
  }
  // const results = await Promise.all(requests);
  // console.log(results);
  browser.close();
};

/**
 * 执行页面，收集性能数据信息
 *
 * @param {*} page
 * @param {*} url
 */
const collectTiming = async (page, url) => {
  return await page.evaluate(url => {
    const pt = window.performance.timing;

    const { href, id } = url;

    return {
      href,
      id,
      allEnd: window.allEnd - pt.navigationStart
    };
  }, url);
};

/**
 * 打开某个页面，执行并收集数据
 *
 * @param {*} browser
 * @param {*} url
 */
const runPage = async (browser, url) => {
  try {
    const page = await browser.newPage();
    const { href, arr } = url;
    let eventType = 'domcontentloaded';

    await page.emulate(iPhone);

    await page.goto(href, {});

    await page.waitForFunction('window.allEnd > 0');

    const dimensions = await collectTiming(page, url);

    console.log(dimensions.allEnd);

    arr.push(dimensions.allEnd);

    await page.close();
  } catch (err) {
    console.log(err);
    return null;
  }
};

/**
 * 每个页面跑n次来获取测试数据
 *
 * @param {*} n
 */
const iterateTimes = async (urls, n = 2) => {
  for (let i = 0; i < n; i++) {
    await runBrowser(urls);
  }
};

module.exports = {
  iterateTimes
};
