const historyDAO = require('../dao/historyDAO');

let findAllPagination = async(path = '', pageSize = 20, currentPage = 1) => {
  let logs = await historyDAO.findAllPagination(path, pageSize, currentPage);
  let data;
  if (logs) {
    data = {
      code: 0,
      desc: '查询成功！',
      totalCount: logs.count,
      data: logs.rows
    }
    console.log(logs);
  } else {
    data = {
      code: 1,
      desc: '查询失败！',
      totalCount: 0,
      data: null
    }
  }
  return data;
}

module.exports = {
  findAllPagination: findAllPagination,
  createOne: historyDAO.createOne,
  updateOne: historyDAO.updateOne
}
