const model = require('../config/model');

let History = model.History;

// History.sync();

module.exports = {
  createOne: async(fileObj = {}) => {
    const {
      result,
      type,
      owner,
      day
    } = fileObj;

    try {
      let newLog = await History.create({
        result,
        type,
        day,
        owner
      });
      return true;
    } catch (e) {
      return false;
    }
  },
  updateOne: async(fileObj = {}) => {
    const {
      result,
      type,
      owner
    } = fileObj;

    try {
      let updateLog = await History.update({
        owner,
        action
      }, {
        where: {
          type
        }
      });
      return true;
    } catch (e) {
      return false;
    }
  },
  findAllPagination: async(type, pageSize, currentPage) => {
    type = type || '';
    let logs = await History.findAndCountAll({
      where: {
        type: {
          $like: '%' + type + '%'
        }
      },
      'order': [
        ['createdAt', 'DESC']
      ]
    })
    return logs;
  },
};
