import Vue from 'vue'
import VueRouter from "vue-router"
import VueResource from 'vue-resource'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import App from './App.vue'
import Index from './components/trend/Index.vue'

import Todo from './components/todo/Index.vue'
import History from './components/history/Index.vue'
import Force from './components/force/Index.vue'
import 'comstyle/layout.less';

Vue.use(VueRouter)
Vue.use(VueResource)
Vue.use(ElementUI)

const router = new VueRouter({
	base: __dirname,
	routes: [{
		path: '/',
		redirect: '/home'
	}, {
    path: '/home',
    component: Index,
    meta: {
    // 需要补全链接
      shouldComplementary: true
    }
  },
  {
    path: '/list',
    component: Todo
  }, {
    path: '/log',
    component: History
  }, {
    path: '/force',
    component: Force
  }]
})

new Vue({
	el: '#app',
	router: router,
	render: h => h(App)
})
