/*
 * @Author: ygy
 * @Date: 2018-03-14 19:39:46
 * @Last Modified by: ygy
 * @Last Modified time: 2018-03-23 18:02:07
 */

const historyService = require('../services/historyService');
const date = require('../utils/date');
const timing = require('./timing');

const runTiming = async () => {
  const task = [
    {
      id: 'turnCircle_1',
      name: '圆形大转盘1',
      href:
        'http://activity.tuiapple.com/activity/index?id=5644&slotId=2380&login=normal&appKey=3p1fqtfC3x5krVrsgCmdSx68JPPj&deviceId=b17b1d5e-7dba-4a55-bedb-26ff10bec388&dsm=1.2380.0.0&tenter=SOW&tck_rid_6c8=0a1b5a39jat135tf-6340031&tck_loc_c5d=tactivity-4783&dcm=401.2380.0.0&&tenter=SOW&tck_userId_674=null'
    },
    {
      id: 'smashg_2',
      name: '砸彩蛋2',
      href:
        'https://activity.tuiapple.com/activity/index?id=6322&slotId=2380&login=normal&appKey=3p1fqtfC3x5krVrsgCmdSx68JPPj&deviceId=b17b1d5e-7dba-4a55-bedb-26ff10bec388&dsm=1.2380.0.0&tenter=SOW&tck_rid_6c8=0a1b5a39jat135tf-6340031&tck_loc_c5d=tactivity-4783&dcm=401.2380.0.0&&tenter=SOW&tck_userId_674=null'
    },
    {
      id: 'wallet_3',
      name: '卡包3',
      href:
        'https://activity.tuiapple.com/activity/index?id=6225&slotId=2380&login=normal&appKey=3p1fqtfC3x5krVrsgCmdSx68JPPj&deviceId=b17b1d5e-7dba-4a55-bedb-26ff10bec388&dsm=1.2380.0.0&tenter=SOW&tck_rid_6c8=0a1b5a39jat135tf-6340031&tck_loc_c5d=tactivity-4783&dcm=401.2380.0.0&&tenter=SOW&tck_userId_674=null'
    }
  ];

  const taskResults = await timing.iterateTimes(task, 2);

  taskResults.map(async page => {
    const arr = page['arr'].map(item => item['whiteTime']);

    const total = arr.reduce((total, item) => {
      return total + item;
    });

    const per = total / (arr.length || 1);

    await historyService.createOne({
      result: JSON.stringify({ whiteTime: per }),
      owner: page.name,
      type: page.id,
      day: date.dateFormat(new Date(), 'yyyy-MM-dd')
    });
  });
};

// runTiming();

module.exports = {
  runTiming
};
