const historyService = require('../services/historyService');

module.exports = {
  'GET /history/list': async (ctx, next) => {
    const { type = ''} = ctx.request.query;

    let logs = await historyService.findAllPagination(
      type
    );
    ctx.response.body = JSON.stringify(logs);
  },
  'GET /history/create': async (ctx, next) => {
    await historyService.createOne({
      result: JSON.stringify({ all: 1020.1 }),
      owner: 'test',
      type: '发发发',
      day: '2018-03-02'
    });
    ctx.rest({
      code: 0,
      data: null
    });
  }
};
