import Vue from 'vue'
import VueRouter from "vue-router"
import VueResource from 'vue-resource'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import App from './App.vue'
import Signin from './components/signin/Signin.vue'
import Signup from './components/signup/Signup.vue'

Vue.use(VueRouter)
Vue.use(VueResource)
Vue.use(ElementUI)

const router = new VueRouter({
  // mode: 'history',
  base: __dirname,
  routes: [{
    path: '/',
    redirect: '/signin'
  }, {
    path: '/signin',
    component: Signin
  }, {
    path: '/signup',
    component: Signup
  }]
})

new Vue({
  el: '#app',
  router: router,
  render: h => h(App)
})
