const puppeteer = require('puppeteer');
const devices = require('puppeteer/DeviceDescriptors');
const iPhone = devices['iPhone 6'];

/**
 * 每个页面一个任务跑n次来获取测试数据
 *
 */
const iterateTimes = async (task, n = 2) => {
  const allTaskResult = [];
  for (let i = 0; i < n; i++) {
    allTaskResult.push(await runBrowser(task));
  }

  return await groupPage(allTaskResult, task);
};

const groupPage = async (allTaskResult, task) => {
  const taskCopy = JSON.parse(JSON.stringify(task));

  allTaskResult.forEach(taskResult => {
    taskResult.forEach((page, index) => {
      const unitTaskCopy = taskCopy[index];

      if (!unitTaskCopy['arr']) {
        unitTaskCopy['arr'] = [];
      }

      unitTaskCopy['arr'].push(page);
    });
  });

  return taskCopy;
};

/**
 * 启用无头浏览器，根据任务里的页面地址去循环执行
 */
const runBrowser = async task => {
  const browser = await puppeteer.launch({
    args: ['--no-sandbox', '--disable-setuid-sandbox']
  });

  const taskResult = [];
  for (const unitTask of task) {
    taskResult.push(await runPage(browser, unitTask));
  }

  browser.close();

  return taskResult;
};

/**
 * 打开某个页面，执行并收集数据
 *
 * @param {*} browser
 * @param {*} unitTask
 */
const runPage = async (browser, unitTask) => {
  try {
    const page = await browser.newPage();
    const { href, arr } = unitTask;

    await page.emulate(iPhone);

    await page.goto(href, {});

    await page.waitForFunction('window.allEnd > 0');

    const testResult = await collectTiming(page, unitTask);

    await page.close();

    return testResult;
  } catch (err) {
    throw err;
  }
};

/**
 * 执行页面，收集性能数据信息
 *
 * @param {*} page
 * @param {*} unitTask
 */
const collectTiming = async page => {
  return await page.evaluate(() => {
    const pt = window.performance.timing;

    return {
      whiteTime: window.allEnd - pt.navigationStart
    };
  });
};

module.exports = {
  iterateTimes
};
