const config = require('../config/config');
const unicode = require('../utils/unicode');
const userService = require('../services/userService');

let signup = async(ctx, next) => {
  const {
    username,
    password,
    name,
    department
  } = ctx.request.body;

  if (!username || !password || !name || !department) {
    ctx.rest({
      code: 1,
      desc: '参数异常！'
    })
  }

  //数据库查询该用户是否存在
  let userExist = await userService.userExist(username);
  if (userExist) {
    ctx.rest({
      code: 1,
      desc: '该用户名已注册！'
    })
  } else {
    let newUser = await userService.createUser({
      username,
      name,
      department,
      password
    });
    ctx.rest({
      code: 0,
      desc: '注册成功！'
    })
  }
};

let signin = async(ctx, next) => {
  let
    username = ctx.request.body.username,
    password = ctx.request.body.password;
  if (!username || !password) {
    ctx.rest({
      code: 1,
      desc: '参数异常！'
    })
  }

  let user = await userService.userCorrect(username, password);
  console.log(user)
  if (user) {
    //响应中设置cookie
    let wdata = user.id + '_' + unicode.unicode(user.name) + '_' + user.username;

    ctx.cookies.set(
      'wdata-oss',
      wdata, config.cookie
    )
    ctx.rest({
      code: 0,
      desc: '登录成功！'
    })
  } else {
    ctx.rest({
      code: 1,
      desc: '登录失败！'
    })
  }
};

const getInfo = async(ctx, next) => {
  const wdata = ctx.cookies.get('wdata-oss');
  let user;
  if (!wdata) {
    user = '缔造';
  } else {
    const unicode = require('../utils/unicode');
    user = unicode.reconvert(wdata.split('_')[1]);
  }
  ctx.rest({
    code: 0,
    data: user
  })
};

const getUserId = async(ctx, next) => {
  const wdata = ctx.cookies.get('wdata-oss');
  let id;
  if (!wdata) {
    id = 'dizao';
  } else {
    id = wdata.split('_')[2];
  }
  ctx.rest({
    code: 0,
    data: id
  })
};

module.exports = {
  'POST /user/signup': signup,
  'POST /user/signin': signin,
  'GET /user/info': getInfo,
  'GET /user/id': getUserId
};
