var path = require('path');
var glob = require('glob');
const isProd = process.env.NODE_ENV === 'production';
// ----- 动态查找所有入口entry文件 ----- //
var files = glob.sync('./src/containers/*/main.js');
var entryList = {};

// 匹配入口文件
files.forEach(function (f) {
  var mainName = /.*\/(containers\/.*?\/main)\.js/.exec(f)[1]; // 得到containers/mobile/main.js这样的文件名
  var mainPath = mainName.split('main')[0]; // 得到containers/mobile/这样的文件名
  var fileName = mainPath.split('/')[1];

  // 记录入口文件
  entryList[fileName] = f;
});

Object.keys(entryList).forEach(function (k) {
  var arr = [];
  arr.push(entryList[k]);
  entryList[k] = arr;
});

module.exports = {
  entry: entryList,
  output: {
    path: path.resolve(__dirname, '../dist'),
    publicPath: process.env.NODE_ENV === 'production' ? 'http://yun.dui88.com/tuia/cdn/' : '/dist' ,
    filename: '[name].js'
  },
  resolve: {
    extensions: ['.js', '.vue'],
    alias: {
      'comcomp': path.resolve(__dirname, '../src/components'),
      'comstyle': path.resolve(__dirname, '../src/styles')
    }
  },
  module: {
    rules: [{
        test: /\.vue$/,
        loader: 'vue-loader',
        options: {
          loaders: {}
          // other vue-loader options go here
        }
      },
      {
        test: /\.js$/,
        loader: 'babel-loader',
        exclude: /node_modules/
      },
      {
        test: /\.less$/,
        loaders: 'style-loader!css-loader!less-loader'
      },
      {
        test: /\.css$/,
        loader: 'style-loader!css-loader'
      },
      {
        test: /\.(eot|svg|ttf|woff|woff2)(\?\S*)?$/,
        loader: 'file-loader'
      },
      {
        test: /\.(png|jpg|gif|svg)$/,
        loader: 'file-loader',
        options: {
          name: '[name].[ext]?[hash]'
        }
      }
    ]
  }
}

function getIPAdress() {
  var interfaces = require('os').networkInterfaces();
  for (var devName in interfaces) {
    var iface = interfaces[devName];
    for (var i = 0; i < iface.length; i++) {
      var alias = iface[i];
      if (alias.family === 'IPv4' && alias.address !== '127.0.0.1' && !alias.internal) {

        return alias.address;
      }
    }
  }
}
