
const userDao = require('../dao/userDAO');

const checkLogin = async(ctx, next) => {
  //首页、登录、注册页面不需要判断登录
  if (ctx.request.url === '/' ||
    ctx.request.url === '/user/signin' ||
    ctx.request.url === '/user/signup' ||
    ctx.request.url === '/api/upload4Sword' ||
    ctx.request.url === '/dist/public.js' ||
    ctx.request.url === '/cdn/flush'
  ) {
    await next();
  } else {
    const wdata = ctx.cookies.get('wdata-oss'); //获取cookie
    if (wdata && wdata.indexOf('_') > 0) {
      const uid = wdata.split('_')[0];
      var user = await userDao.findOneById(uid);
      if (user) {
        await next();   //如果cookie解析正确且查询到具体User，则继续中间件
      } else {
        ctx.response.redirect('/#/signin');   //否则引导至登录页面
      }
    } else {
      ctx.response.redirect('/#/signin');
    }
  }
};

module.exports = {
  checkLogin
};
