### 背景

公司有一个专用于管理CDN文件上传的系统，该系统全公司各个部门的人都会经常使用到。

之前的工具虽然很稳定，但是界面稍显简陋，代码比较复杂不利于维护。
这次改造希望优化代码架构，简化业务，增加几个必要的功能。

最重要的原因是借助这个项目锻炼自己的技术能力，以及项目管理的能力。

### 功能点分析
Oss工具主要功能模块有：
#### 文件管理：
1. 列出文件和文件夹、文件信息【区分文件夹、常用文件类型图标】
2. 新建文件夹
3. 文件操作（上传、删除）
4. 获取文件链接地址
5. 文件查询（根据文件名模糊查询）
6. 当前文件夹根据文件名过滤
7. 文件同步（从测试bucket同步到线网bucket）
#### 日志管理
1. 已上传文件列表（记录上传人）
2. 文件同步列表（管理员才可同步）
3. 失败列表、异常日志信息、文件删除日志
#### 用户权限管理
普通用户
管理员

### 技术选型
项目的业务逻辑比较简单，尝试使用前后端分离的js全栈方案。
#### 服务端
考虑到nodejs已经可以升级到7.7，原生支持async和await方法了，Koa2使用async/await处理异步事件，是以后的趋势。
所以后端的技术栈设计为：
> Koa2 + Nodejs

#### 网页端
使用vue全家桶 + elementUI
使用vue的原因是vue文档更友好，比较容易上手，现在vue2.0的生态也比较丰富，能很好的涵盖需要的功能。
elementUI用于搭建前端界面，有非常完善的组件样式和对应的示例，对新手友好。

网页端技术栈为：

> vue2.0 (vue + vue-router + vue-resouce) + elementUI