from time import sleep

import requests

from log import LOG


class PG:
    def __init__(self):
        self.host = 'https://ssp-manager.tuia.cn'
        # 盘古获取待巡查列表接口
        self.valid_list_url = '/wchatDomain/wechatScan/openIdAddress?keyStr=wx.openid.redirect.host'
        # 盘古上报被封域名列表,微信扫码巡查使用
        self.block_list_url = 'https://ssp-manager.tuia.cn/wchatDomain/wechatScan/sendDingDing'
        self.session = requests.session()

    def get_valid_list(self):
        LOG.info('开始获取盘古巡查列表')
        r = self.session.get(url=self.host + self.valid_list_url)
        if r.status_code == 200 and r.json().get('desc') == '成功':
            valid_list  = [r.json().get('data')]
            if valid_list:
                LOG.info('获取盘古巡查列表结果：' + str(valid_list))
                return valid_list
        else:
            LOG.error('获取盘古巡查列表异常，repose：' + r.text)


    def post_block_list(self, b_url):
        LOG.info('盘古上报被封域名：'+b_url)
        data = {
            'domain':b_url,
            'type':'1'
        }
        r = self.session.post(url=self.block_list_url,json=data)
        print(r.text)
        if r.status_code == 200 and r.json().get('desc') == "成功":
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)


