from time import sleep

import requests

from log import LOG


class Zk:
    def __init__(self):
        self.host = 'http://zhongkui.tuia.cn'
        # 获取有效可用的域名,ios支付宝域名巡查使用
        self.valid_list_url = '/domain/queryValidDomainList?platformType=3'
        # 上报被封域名列表,ios支付宝域名巡查使用
        self.block_list_url = '/domain/receiveBlockedDomain'

        self.session = requests.session()

    def get_valid_list(self):
        LOG.info('开始获取巡查列表')
        r = self.session.get(url=self.host + self.valid_list_url)
        if r.status_code == 200 and r.json().get('success') == True:
            valid_list = r.json().get('data').get('domains')
            if valid_list:
                LOG.info('获取巡查列表结果：'+str(valid_list))
                return valid_list
        else:
            LOG.error('获取巡查列表异常，repose：'+r.text)

    def post_block_list(self, b_list):
        LOG.info('上报被封域名列表：'+str(b_list))
        data = {'platformType': 3, 'domains': b_list}
        r = self.session.post(url=self.host+self.block_list_url,json=data)
        if r.status_code == 200 and r.json().get('success') == True:
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)



class Tui:

    def __init__(self):
        self.host = 'https://manager.tuia.cn'
        # 获取订单域名列表
        self.bid_list_url = '/advertWeChat/getWeChatForbidDomain'
        # 上报订单被封域名接口
        self.bid_block_url = '/advertWeChat/receiveUnsealDomain'

        self.url_list = '/adverts/urlList'

        self.report_list = '/adverts/reportUrl?url='

        self.finish_url = '/adverts/checkFinish?startTime='
        self.session = requests.session()


    def get_valid_list(self):
        LOG.info('开始获取广告线订单域名巡查列表')
        r = self.session.get(url=self.host + self.bid_list_url)
        if r.status_code == 200 and r.json().get('desc') == '查询成功':
            valid_list = r.json().get('data')
            if valid_list:
                LOG.info('获取巡查列表结果：'+str(valid_list))
                return valid_list
        else:
            LOG.error('获取巡查列表异常，repose：'+r.text)

    def post_block_list(self, b_list):
        LOG.info('上报被封域名列表：'+str(b_list))
        data = {'domainList': b_list}
        r = self.session.post(url=self.host+self.bid_block_url,json=data)
        if r.status_code == 200 and r.json().get('desc') == '接收成功':
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)


    def get_urls(self):
        LOG.info('开始获取广告线被封域名巡查列表')
        r = self.session.get(url=self.host + self.url_list)
        if r.status_code == 200 and r.json().get('desc') == 'success':
            valid_list = r.json().get('data')
            if valid_list:
                LOG.info('获取巡查列表结果：'+str(valid_list))
                return valid_list
        else:
            LOG.error('获取巡查列表异常，repose：'+r.text)

    def report_urls(self, b_url):
        LOG.info('上报被封域名：'+str(b_url))
        r = self.session.get(url=self.host+self.report_list+b_url+'&ck=65f364dcb386fefee8573e96f70659dc')
        if r.status_code == 200 and r.json().get('desc') == 'success':
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败：' + r.text)

    def finish(self,startTime,endTime):
        LOG.info('广告线被封域名巡查完毕' )
        r = self.session.get(url=self.host + self.finish_url + str(startTime) + '&endTime='+str(endTime))
        if r.status_code == 200 and r.json().get('desc') == 'success':
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败：' + r.text)

if __name__ == '__main__':
    tui =Tui()
    print(tui.get_urls())
