from time import sleep

import requests

from log import LOG


class SSP:
    def __init__(self):
        self.host = 'https://ssp-manager.tuia.cn'
        # ssp上报被封域名列表,微信扫码巡查使用
        self.block_list_url = '/wchatDomain/wechatScan/patrolResulting?shieldDomain='
        # ssp获取待巡查列表接口
        self.valid_list_url = '/wchatDomain/wechatScan/patrolListing'
        # 盘古上报被封域名列表,微信扫码巡查使用
        self.block_pg_list_url = 'https://ssp-manager.tuia.cn/wchatDomain/wechatScan/sendDingDing'
        self.session = requests.session()

    def get_valid_list(self):
        LOG.info('开始获取巡查列表')
        r = self.session.get(url=self.host + self.valid_list_url)
        if r.status_code == 200 and r.json().get('desc') == '成功':
            data = r.json().get('data')
            valid_list = []
            for i in data:
                valid_list.append(i.get('domainName'))
            if valid_list:
                LOG.info('获取巡查列表结果：' + str(valid_list))
                return valid_list
        else:
            LOG.error('获取巡查列表异常，repose：' + r.text)

    def post_block_list(self, b_url):
        LOG.info('SSP上报被封域名：'+b_url)
        r = self.session.get(url=self.host+self.block_list_url+b_url.split('https://')[1]+'&resulting=1')
        LOG.info('上报结果：' + r.text)
        if r.status_code == 200 and r.json().get('desc') == "成功":
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)

    def post_pg_block_list(self, b_url):
        LOG.info('盘古上报被封域名：'+b_url)
        data = {
            'domain':b_url,
            'type':'1'
        }
        r = self.session.post(url=self.block_pg_list_url,json=data)
        print(r.text)
        if r.status_code == 200 and r.json().get('desc') == "成功":
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)



if __name__ == '__main__':
    ssp = SSP()
    ssp.get_valid_list()
