from time import sleep

import requests

from log import LOG


class SSP:
    def __init__(self):
        self.host = 'https://ssp-manager.tuia.cn'
        # ssp上报被封域名列表,微信扫码巡查使用
        self.block_list_url = '/wchatDomain/wechatScan/patrolResulting?shieldDomain='
        # 盘古上报被封域名列表,微信扫码巡查使用
        self.block_pg_list_url = 'https://ssp-manager.tuia.cn/wchatDomain/wechatScan/sendDingDing'
        self.session = requests.session()

    def post_block_list(self, b_url):
        LOG.info('SSP上报被封域名：'+b_url)
        r = self.session.get(url=self.host+self.block_list_url+b_url.split('https://')[1]+'&resulting=1')
        if r.status_code == 200 and r.json().get('desc') == "成功":
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)

    def post_pg_block_list(self, b_url):
        LOG.info('盘古上报被封域名：'+b_url)
        data = {
            'domain':b_url,
            'type':'1'
        }
        r = self.session.post(url=self.block_pg_list_url,json=data)
        print(r.text)
        if r.status_code == 200 and r.json().get('desc') == "成功":
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)




