from airtest.core.api import *
from poco.drivers.ios import iosPoco

from dingMessage import send_messages
from log import LOG
from manager import Zk
from ssp import SSP


def runner(channel):

    url_list = channel.get_valid_list()
    # url_list= ['activity.zadtc.com']
    for i in url_list:
        try:
            LOG.info('点击输入框')
            poco(type='TextField').click()
            sleep(0.5)
            LOG.info('输入待巡查链接:'+ i)
            if i.startswith('http'):
                text(i)
            else:
                text('https://'+i)
            sleep(0.77)
            LOG.info('点击确定按钮')
            # touch(Template(r"tpl1648539686506.png", record_pos=(-0.263, -0.665), resolution=(1440, 2560)))
            poco(name='确定').click()
            LOG.info('正在巡查：' + i)
            sleep(2)
            try:
                if poco(name="已停止访问该网页").exists():
                    LOG.info('巡查结束，域名被封：%s' % i)
                    try:
                        channel.post_block_list(i)
                    except:
                        send_messages('上报微信被封域名失败：' + channel.__class__.__name__)
                else:
                    LOG.info('巡查结束，域名正常：' + i)
            except TargetNotFoundError:
                LOG.info('巡查结束，域名正常：' + i)
            poco(name='返回').click()
            sleep(0.5)
            touch(Template(r"tpl1650007378767.png", record_pos=(0.429, -0.911), resolution=(828, 1792)))
            touch(Template(r"tpl1650007403842.png", record_pos=(0.085, 0.708), resolution=(828, 1792)))
        except Exception as e:
            LOG.error('微信扫码域名巡查,执行巡查时脚本出错:'+str(e))
            re_wx()
    # touch(Template(r"tpl1648203197604.png", record_pos=(-0.437, -0.758), resolution=(1440, 2560)))
    # touch(Template(r"tpl1648543114629.png", record_pos=(0.005, -0.516), resolution=(1440, 2560)))
def check_ex():
    LOG.info('判断是否在微信首页')
    if not poco("快捷操作").exists():
        LOG.info('不在微信首页，重新打开微信')
        device.stop_app('com.tencent.xin')
        device.start_app('com.tencent.xin')


def scan():
    LOG.info('打开扫一扫，选择二维码')
    poco("快捷操作").wait(timeout=5).click()
    poco("扫一扫").wait(timeout=5).click()
    wait(Template(r"tpl1644909001064.png", record_pos=(0.396, 0.696), resolution=(828, 1792)), timeout=5)
    touch(Template(r"tpl1644909001064.png", record_pos=(0.396, 0.696), resolution=(828, 1792)))
    poco('照片3,拍摄时间,2022年4月15日 下午3:00').wait(timeout=5).click()
    poco(name="完成").wait(timeout=5).click()


def check_wx():
    LOG.info('判断微信是否异常')
    while poco(name="下一步").exists():
        LOG.info('微信异常，点击下一步')
        poco(name="下一步").click()
    if poco(name="进入微信").exists():
        LOG.info('点击进入微信')
        poco(name="进入微信").click()

def re_wx():
    device.stop_app('com.tencent.xin')
    device.start_app('com.tencent.xin')
    check_ex()
    check_wx()


if __name__ == '__main__':
    ssp = SSP()
    # zk = Zk()
    LOG.info('开始连接设备')
    device = connect_device('ios:///http://127.0.0.1:8100')
    LOG.info('连接成功')
    poco = iosPoco()
    while True:
        try:
            check_ex()
            check_wx()
            scan()
            # runner(zk)
            runner(ssp)
        except Exception as e:
            print(e)
            LOG.error('微信扫码域名巡查脚本报错,三分钟后重试！')
            sleep(30)




