from airtest.core.api import *
from poco.drivers.ios import iosPoco
from log import LOG
from ssp import SSP


def check_ex():
    LOG.info('判断是否在微信首页')
    if not poco("快捷操作").exists():
        LOG.info('不在微信首页，重新打开微信')
        device.stop_app('com.tencent.xin')
        device.start_app('com.tencent.xin')
    if poco("扫一扫").exists():
        poco("快捷操作").click()


def check_wx():
    LOG.info('判断微信是否异常')
    while poco(name="下一步").exists():
        LOG.info('微信异常，点击下一步')
        poco(name="下一步").click()
    if poco(name="进入微信").exists():
        LOG.info('点击进入微信')
        poco(name="进入微信").click()


def scan(photo):
    block_list = []
    LOG.info('打开扫一扫，选择二维码')
    poco("快捷操作").wait(timeout=5).click()
    poco("扫一扫").wait(timeout=5).click()
    wait(Template(r"tpl1644909001064.png", record_pos=(0.396, 0.696), resolution=(828, 1792)),timeout=5)
    touch(Template(r"tpl1644909001064.png", record_pos=(0.396, 0.696), resolution=(828, 1792)))
    poco(photo).wait(timeout=5).click()
    poco(name="完成").wait(timeout=5).click()
    poco(type="Link").wait(timeout=5)
    links = poco(type="Link")
    for link in links:
        link.click()
        sleep(1.5)
        if poco(name="已停止访问该网页").exists():
            block_list.append(link.get_name())
        poco(name="返回").wait(timeout=5).click()
    LOG.info('巡查结束，关闭扫码webview！')
    poco(name="关闭").wait(timeout=5).click()
    return block_list


def check_ssp():
    LOG.info('巡查ssp')
    b_list = scan("照片1,拍摄时间,2022年2月17日 下午4:47")
    if b_list:
        LOG.info('巡查ssp结束，被封列表：' + str(b_list))
        for domain in b_list:
            ssp.post_block_list(domain)


def check_pg():
    LOG.info('巡查盘古')
    b_list = scan("照片2,拍摄时间,2022年2月17日 下午4:47")
    if b_list:
        LOG.info('巡查盘古结束，被封列表：'+str(b_list))
        for domain in b_list:
            ssp.post_block_list(domain)


if __name__ == '__main__':

    ssp = SSP()
    LOG.info('开始连接设备')
    device = connect_device('ios:///http://127.0.0.1:8100')
    LOG.info('连接成功')
    poco = iosPoco()
    while True:
        try:
            check_ex()
            check_wx()
            check_ssp()
            check_pg()
        except Exception as e:
            print(e)
            LOG.error('域名巡查脚本报错,三分钟后重试！')
            sleep(30)