from time import sleep
from urllib.parse import urlparse
import requests

from dingMessage import send_messages
from log import LOG
from manager import Tui


def check_domain(check_url,i=0):
    try:
        sleep(1)

        if check_url.startswith('http'):
            gj_url = check_url
            url = base_url + check_url  # 将待巡查链接拼接到巡查接口后面
        else:
            gj_url = 'https://'+ check_url
            url = base_url + gj_url

        LOG.info('广告主开始巡查，域名为：%s' % check_url)
        r = session.get(url=url,headers=headers,timeout=5)  # 调用微信官方接口进行域名巡查
        res_url = r.url  # 获取最终的url，如果被封，则应该是微信安全中心的链接
        LOG.info('巡查最终打开页面链接：%s' % res_url)  # 将url打印出来，便于后期排查问题
        host = urlparse(res_url).hostname  # 判断域名，如果是微信安全中心的域名'weixin110.qq.com'，则说明被封
        if host and host == 'weixin110.qq.com':
            LOG.info('巡查结束，域名被封：%s' % check_url)
            send_messages('广告主落地页链接被封，被封链接为：'+gj_url)
        else:
            LOG.info('巡查结束，域名正常：%s' % check_url)

    except requests.exceptions.ConnectionError:
        LOG.error('域名连接异常：' + check_url)
        pass
    except:
        if i < 3:
            i += 1
            LOG.error('微信域名巡查,执行巡查时脚本出错,正在进行第' + str(i) + '次重试')
            sleep(20)
            check_domain(check_url, i)
        else:
            LOG.error('微信域名巡查脚本，执行巡查时出错，请及时处理！！！')

def get_pg_list():
    pg_url = 'https://engine.tuia.cn/apollo/getIdMapStrByKeyStr?keyStr=wx.ad.page'
    r = requests.get(url=pg_url)
    pg_lsit = []
    if r.ok:
        res = eval(r.text)
        for k,v in res.items():
            pg_lsit.append(v)
    return pg_lsit



if __name__ == '__main__':
    base_url = 'http://mp.weixinbridge.com/mp/wapredirect?url='  # 微信官方接口，可用于域名巡查，后面拼接上需要巡查的域名或链接
    session = requests.session()
    headers = {'User-Agent':'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36'}

    while True:
        try:
            ck_url_list = get_pg_list()
            for ck_url in ck_url_list:
                check_domain(ck_url)
                sleep(2)
            sleep(10)
        except:
            sleep(10)
            pass








