import requests

from log import LOG

# 全民对接
class QM:
    def __init__(self):
        self.host = 'https://gateway.hjff18.com'
        # ssp上报被封域名或链接
        self.block_list_url = '/mall/domain/ta/jc'
        self.session = requests.session()

    def post_block_list(self, b_url):
        LOG.info('全民上报被封域名：'+b_url)
        if b_url.startswith('http'):
            r = self.session.post(url=self.host+ self.block_list_url,json={'domain':b_url})
        else:
            b_url = 'https://' + b_url
            data = {
                'domain': b_url
            }
            r = self.session.post(url=self.host+ self.block_list_url,json=data)
        print('上报结果：' + r.text)
        if r.status_code == 200 and r.json().get('desc') == "成功":
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)



if __name__ == '__main__':
    qm = QM()
    qm.post_block_list('www.baidu.com')
