from time import sleep

import requests

from log import LOG


class Zk:
    def __init__(self):
        self.host = 'http://zhongkui.tuia.cn'
        # 获取有效可用的域名,ios支付宝域名巡查使用
        self.valid_list_url = '/domain/queryValidDomainList?platformType=3'
        # 上报被封域名列表,ios支付宝域名巡查使用
        self.block_list_url = '/domain/receiveBlockedDomain'

        self.session = requests.session()

    def get_valid_list(self):
        LOG.info('开始获取巡查列表')
        r = self.session.get(url=self.host + self.valid_list_url)
        if r.status_code == 200 and r.json().get('success') == True:
            valid_list = r.json().get('data').get('domains')
            if valid_list:
                LOG.info('获取巡查列表结果：'+str(valid_list))
                return valid_list
        else:
            LOG.error('获取巡查列表异常，repose：'+r.text)

    def post_block_list(self, b_list):
        LOG.info('上报被封域名列表：'+str(b_list))
        data = {'platformType': 3, 'domains': b_list}
        r = self.session.post(url=self.host+self.block_list_url,json=data)
        if r.status_code == 200 and r.json().get('success') == True:
            LOG.info('上报成功：'+ r.text)
        else:
            LOG.error('上报失败，1.5S后重新上报：' + r.text)



