'use strict';

import React from 'react';
import { RES_PATH } from '../../../sparkrc.js';
import { observer } from 'mobx-react';
import store from '../../store/index';
import modalStore from '@src/store/modal';
import API from '../../api';
import getShareApi from '@spark/api-share'; // 分享玩法组件包
import getBindPhoneApi from '@spark/api-bindPhone'; // 绑定手机号玩法组件包
import getCarouselApi from '@spark/api-carousel'; // 轮播玩法组件包
import Swiper from 'swiper'; // 引入swiper
import { Toast } from '@spark/ui'; // 引入Toast
import { _throttle } from '../../utils/utils'; // 引入节流
import PubSub from 'pubsub-js'; // 引入pubsub-js
import './homePage.less';

@observer
class HomePage extends React.Component {
  constructor(props) {
    super(props);
  }

  initValue = 60 // 定义倒计时秒数

  state = {
    timer: this.initValue, // 倒计时数
  }

  componentDidMount() {
    // 订阅消息-消息名：“isClick”
    this.token = PubSub.subscribe('isClick',(msg,data) => {
      this.countDown();
    });

    // 获取轮播数据
    const carouselApi = getCarouselApi('Yh');
    carouselApi.query()
      .then(res => {
        this.setState({
          imgData: res.list,
        })
      })
      .catch(err => {
        console.log(err);
      });

    // 定时器，防止轮播图只播放一次就不播放了
    setTimeout(() => {
      // 初始化swiper
      new Swiper(".swiper-container1", {
        pagination: '.swiper-pagination',
        paginationClickable: true,
        autoplay: 1500,
        loop: true,
      });
    }, 500)
  }

  componentWillUnmount() {
    PubSub.unSubscribe(this.token); // 取消订阅
  }

  // 分享
  onShare = () => {
    const shareApi = getShareApi("Yh");

    // let obj = shareApi.doShare();
    // console.log(obj); // 是个Promise对象-分享

    shareApi.doShare()
      .then(res => {
        modalStore.pushPop('SharePopUp', { res })
      })
      .catch(err => {
        console.log(err);
      });

    // let obj1 = shareApi.queryCount();
    // console.log(obj1); // 是个Promise对象-查询次数

    shareApi.doShare()
      .then(res => {
        // console.log(res);
      })
      .catch(err => {
        console.log(err);
      });
  }

  // 点击“获取验证码”
  getCode = _throttle(() => {
    const { username } = this;
    let phoneNumber = username.value; // 获取到输入的手机号
    const reg_tel = /^1[3|4|5|7|8]\d{9}$/; // 手机号的正则表达式
    // if (phoneNumber == '') {
    //   Toast('请输入手机号');
    //   return;
    // } else if (!reg_tel.test(phoneNumber)) {
    //   Toast('请输入正确的手机号格式');
    //   return;
    // } else {
      modalStore.pushPop('SlideVerify'); // 打开滑块验证组件
    // }
  })

  // 倒计时
  countDown = () => {
    this.setState({
      isClick: true, // true->开始倒计时
    })
    let auth_timer = setInterval(() => {
      // 定时器设置每秒递减
      const new_timer = this.state.timer - 1; // 递减时间
      this.setState({
        timer: new_timer,
      })
      if (this.state.timer <= 0) {
        this.setState({
          isClick: false, // true->开始倒计时
        })
        clearInterval(auth_timer);
        this.setState({
          timer: this.initValue,
        })
      }
    }, 1000)
    // 发送验证码
    const bindPhoneApi = getBindPhoneApi('Yh');
    bindPhoneApi.sendSmsCode();
  }

  clickSlide = () => {
    console.log('点击观看视频');
  }

  render() {
    return (
      <div className="homePage">
        <span className="activityRules" onClick={this.onShare}></span>
        <div className="form">
          <div className='marginBottom'>手机号：<input ref={(e) => { this.username = e }} type="text" name="phone" /></div>
          <div>验证码：<input ref={(e) => { this.code = e }} type="text" name="verifyCode" />
            {
              this?.state?.isClick ?
                <span className="btn">{this.state.timer}s</span> :
                <span className="btn" onClick={this.getCode}>获取验证码</span>
            }
          </div>
        </div>
        {/* Swiper */}
        <div className="swiper-container swiper-container1">
          <div className="swiper-wrapper">
            {
              this?.state?.imgData?.map((item, index) => {
                return (
                  <div className="swiper-slide swiper-slide1" key={index}>
                    <div className="banner_img" onClick={this.clickSlide}>
                      <img src={item} alt="" />
                      <span className='tip'>点击观看视频</span>
                    </div>

                  </div>
                )
              })
            }
          </div>
          {/* Add Pagination */}
          <div className="swiper-pagination"></div>
        </div>
      </div>
    );
  }
}

export default HomePage;
