'use strict';

import React from 'react';
import { RES_PATH } from '../../../sparkrc.js';
import { observer } from 'mobx-react';
import store from '../../store/index';
import modalStore from '@src/store/modal';
import API from '../../api';
import { Toast } from '@spark/ui'; // 引入Toast
import ReactSimpleVerify from 'react-simple-verify'; // 引入react滑块验证
import PubSub from 'pubsub-js'; // 引入pubsub-js
import 'react-simple-verify/dist/react-simple-verify.css'; // 引入react滑块验证的css
import './SlideVerify.less';

@observer
class SlideVerify extends React.Component {
    constructor(props) {
        super(props);
    }

    // 开启倒计时
    startCountDown = () => {
        // 发布消息-消息名：“isClick”
        PubSub.publish('isClick');
    }

    // 验证成功之后进行的操作
    success = () => {
        modalStore.closePop('SlideVerify'); // 关闭滑块验证组件
        // didClose是Toast的回调函数
        Toast('验证成功', 1500, {
            didClose: this.startCountDown
        });
    }

    render() {
        return (
            <div className='slideVerify'>
                {/* react滑块组件 */}
                <ReactSimpleVerify ref="verify" success={this.success.bind(this)} />
            </div>);
    }
}

export default SlideVerify;
