'use strict';

import React from 'react';
import { RES_PATH } from '../../../sparkrc.js';
import { observer } from 'mobx-react';
import store from '../../store/index';
import modalStore from '@src/store/modal';
import API from '../../api';
import { dateFormatter } from '../../utils/utils'; // 引入日期格式化
import './sharePopup.less';

@observer
class SharePopUp extends React.Component {
    constructor(props) {
        super(props);
    }

    render() {
        const { res } = this.props.popData;
        return (
            <div className="sharePopup">
                <p className='date'>{dateFormatter(res.timestamp, "yyyy-MM-dd")}</p>
                <div className="shareCode">分享码：{res.shareCode}</div>
                <div className="shareNum">第{res.index}次分享</div>
                <div className="isIssuePrize">是否发奖：<span>{res.sendPrize ? '是' : '否'}</span></div>
                <div className={'prizeDetail' + ' ' + (!res.sendPrize ? 'displayNone' : '')}>
                    {
                        res?.options?.map((item, index) => {
                            return (
                                <div className="prize" key={item.optionId}>
                                    <div className="name">奖品名称：{item.optionName}</div>
                                    <div className="img">奖品图片：{item.optionImg}</div>
                                    <div className="style">奖品类型：{item.prizeType}</div>
                                </div>
                            )
                        })
                    }
                </div>
                <div className="delete" onClick={() => {
                    modalStore.closePop('SharePopUp')
                }}><span>x</span></div>
            </div>
        );
    }
}

export default SharePopUp;
