import React, { Component } from "react";
import ReactDOM from "react-dom";
import {observer} from 'mobx-react';
import "./app.less";
import store from './store/index';
import Modal from './modal/modal';
import './utils/checkWebp'
import MD from '../MD';
MD();

//此处为spark-cli动态生成
import LoadingDemo from "@src/pages/loadingDemo/loadingDemo";
import HomePage from './pages/homePage/homePage'

const pageMap = {
  loading: <LoadingDemo />,
  homePage: <HomePage/>,
}
@observer
class App extends Component {
  async componentDidMount(){
    //获取前端开发配置，依据项目需要，酌情添加 ！！！
    // await store.getFrontVariable(); 
  }
  render() {
    const { curPage  } = store;
    return (
      <div>
        {{...pageMap[curPage], props: {changePage: 'homePage'}}}
        <Modal />
      </div>
    );
  }
}

ReactDOM.render(<App />, document.getElementById("root"));
