// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import ViewUI from 'view-design'
import './styles/theme.less';

import 'viewerjs/dist/viewer.css'

import "core-js/stable"
import App from './App'
import {router} from './router/index'
import store from './store'
import i18n from '@/locale'

import {getRequest, postRequest, putRequest, deleteRequest, importRequest, uploadFileRequest} from '@/libs/axios'
import {setStore, getStore, removeStore} from '@/libs/storage'
import util from '@/libs/util'

import * as filters from '@/utils/filters' // global filter
import i18nBox from '@/components/i18n-translate'
import {md5} from '@/utils/md5.js';
import moment from 'moment';

// 打印
import Print from 'vue-print-nb';
// 复制
import Clipboard from 'v-clipboard';
// 预览
import VueViewer from 'v-viewer';
Vue.use(VueViewer)
Vue.use(Clipboard)
Vue.use(Print);


Vue.config.devtools = true;
Vue.config.productionTip = false
const copyViewUi = {...ViewUI}
Vue.use(copyViewUi, {
  i18n: (key, value) => i18n.t(key, value),
});
Vue.component('i18nBox', i18nBox)


// 挂载全局使用的方法
Vue.prototype.getRequest = getRequest;
Vue.prototype.postRequest = postRequest;
Vue.prototype.putRequest = putRequest;
Vue.prototype.deleteRequest = deleteRequest;
Vue.prototype.importRequest = importRequest;
Vue.prototype.uploadFileRequest = uploadFileRequest;
Vue.prototype.setStore = setStore;
Vue.prototype.getStore = getStore;
Vue.prototype.removeStore = removeStore;
Vue.prototype.md5 = md5;
Vue.prototype.moment = moment;


Array.prototype.remove = function (from, to) {
  var rest = this.slice((to || from) + 1 || this.length);
  this.length = from < 0 ? this.length + from : from;
  return this.push.apply(this, rest);
};

Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})
/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  i18n,
  render: h => h(App),
  data: {
    currentPageName: ''
  },
  mounted() {
    // 初始化菜单
    util.initRouter(this);
    this.currentPageName = this.$route.name;
    // 显示打开的页面的列表
    this.$store.commit('setOpenedList');
    this.$store.commit('initCachePage');
  }
})
