import type { loader } from 'webpack';
import type glob from 'glob';
export declare type Loader = loader.Loader;
export declare type LoaderContext = loader.LoaderContext;
export declare type LoaderCallback = loader.loaderCallback;
export declare type StyleResourcesFileFormat = 'css' | 'sass' | 'scss' | 'less' | 'styl';
export interface StyleResource {
    file: string;
    content: string;
}
export declare type StyleResources = StyleResource[];
export declare type StyleResourcesFunctionalInjector = (this: LoaderContext, source: string, resources: StyleResources) => string | Promise<string>;
export declare type StyleResourcesInjector = 'prepend' | 'append' | StyleResourcesFunctionalInjector;
export declare type StyleResourcesNormalizedInjector = StyleResourcesFunctionalInjector;
export interface StyleResourcesLoaderOptions {
    patterns: string | string[];
    injector?: StyleResourcesInjector;
    globOptions?: glob.IOptions;
    resolveUrl?: boolean;
}
export interface StyleResourcesLoaderNormalizedOptions extends NonNullable<StyleResourcesLoaderOptions> {
    patterns: string[];
    injector: StyleResourcesNormalizedInjector;
}
