"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var axios_1 = require("axios");
var utils_1 = require("./utils");
var address = require("address");
var Netmask = require('netmask').Netmask;
var ip = address.ip() || '127.0.0.1';
var Pool = /** @class */ (function () {
    function Pool(eureka, services) {
        var _this = this;
        this.eurekaObjs = {};
        this.instances = [];
        setTimeout(function () {
            _this.getEurekas(eureka, services);
        }, 3000);
        setInterval(function () {
            _this.filterPool();
        }, 4000);
    }
    /**
     * 遍历eureka
     * @param {Eureka} eureka  Eureka
     * @param {string[]} services 服务名
     */
    Pool.prototype.getEurekas = function (eureka, services) {
        return __awaiter(this, void 0, void 0, function () {
            var _loop_1, this_1, i;
            var _this = this;
            return __generator(this, function (_a) {
                this.instances = [];
                _loop_1 = function (i) {
                    var _a;
                    var name_1 = services[i];
                    var instances = eureka.getInstancesByAppId(name_1);
                    var tmpList = [];
                    instances.map(function (v) {
                        tmpList.push("http://" + v.hostName + ":" + v.port.$);
                    });
                    this_1.eurekaObjs[name_1] = tmpList;
                    (_a = this_1.instances).push.apply(_a, __spread(instances));
                };
                this_1 = this;
                for (i = 0; i < services.length; i++) {
                    _loop_1(i);
                }
                // 每30秒刷新eurekaObjs列表
                setTimeout(function () {
                    _this.getEurekas(eureka, services);
                }, 30000);
                return [2 /*return*/];
            });
        });
    };
    Pool.prototype.filterPool = function () {
        return __awaiter(this, void 0, void 0, function () {
            var eurekaObjs, _a, _b, _i, i, obj, j, params, check, data, e_1;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        eurekaObjs = this.eurekaObjs;
                        _a = [];
                        for (_b in eurekaObjs)
                            _a.push(_b);
                        _i = 0;
                        _c.label = 1;
                    case 1:
                        if (!(_i < _a.length)) return [3 /*break*/, 9];
                        i = _a[_i];
                        obj = eurekaObjs[i];
                        j = 0;
                        _c.label = 2;
                    case 2:
                        if (!(j < obj.length)) return [3 /*break*/, 7];
                        params = '';
                        if (i === 'duiba-manager-web')
                            params = 'newmanager/';
                        check = obj[j] + "/" + params + "monitor/check";
                        _c.label = 3;
                    case 3:
                        _c.trys.push([3, 5, , 6]);
                        return [4 /*yield*/, axios_1.default.get(check, { timeout: 3000 })];
                    case 4:
                        data = (_c.sent()).data;
                        if (utils_1.checkType(data, 'String')) {
                            if (data.toLowerCase() !== 'ok') {
                                eurekaObjs[i].splice(j, 1);
                            }
                        }
                        else {
                            eurekaObjs[i].splice(j, 1);
                        }
                        return [3 /*break*/, 6];
                    case 5:
                        e_1 = _c.sent();
                        eurekaObjs[i].splice(j, 1);
                        return [3 /*break*/, 6];
                    case 6:
                        j++;
                        return [3 /*break*/, 2];
                    case 7:
                        eurekaObjs[i] = eurekaObjs[i].filter(function (v) { return v !== undefined; });
                        _c.label = 8;
                    case 8:
                        _i++;
                        return [3 /*break*/, 1];
                    case 9: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 获取所有eureka
     */
    Pool.prototype.getAllEurekas = function () {
        return this.instances;
    };
    /**
     * 获取所有实例下的host
     */
    Pool.prototype.getAllHostName = function () {
        return this.eurekaObjs;
    };
    Pool.prototype.getRandomHost = function (host) {
        var len = host.length;
        var num = utils_1.random(0, len - 1);
        return host[num] || '';
    };
    Pool.prototype.getHost = function (name, localIp, filterGroup) {
        var _a = this, eurekaObjs = _a.eurekaObjs, instances = _a.instances;
        var pool = eurekaObjs[name];
        if (!pool) {
            console.error('请先注册service');
            process.exit(1);
        }
        var NODE_ENV = process.env.NODE_ENV;
        // if (NODE_ENV === 'prod') {
        //   return this.filterHybridCloud(instances, pool);
        // }
        // 优先走本地
        var hasLocalIp = false;
        var clientIp = '';
        pool = pool.filter(function (v) { return v; });
        for (var i = 0; i < pool.length; i++) {
            if (pool[i].includes(localIp)) {
                hasLocalIp = true;
                clientIp = pool[i];
            }
        }
        if (hasLocalIp) {
            return clientIp;
        }
        /** 最优先匹配具体标记的，即多环境 */
        var highestPriorityList = []; // 最高优先级  匹配到具体的metadata
        var havePriorityList = []; // 优先转发目标   除具体metadata之外的metadata
        /** 没有标记则默认转发到公共服务 */
        var thirdPriorityList = []; // 第三优先级   runInSingleJarMode=true的是公共服务
        /** 个人服务 */
        var noGroupService = []; // 没有分组标记     没有任何标记
        for (var i in instances) {
            var ins = instances[i];
            var host = "http://" + ins.hostName + ":" + ins.port.$;
            var metadata = ins.metadata;
            var group = metadata['duiba.service.group.key'];
            var runInSingleJarMode = metadata['run.in.docker'] === 'true'; // 判断是否是公共服务
            if (filterGroup && group) { // 如果存在_duibaServiceGroupKey 且存在多场景
                if (group === filterGroup) { // 完全匹配metadata
                    highestPriorityList.push(host);
                }
                else if (group) { // 匹配不到，多场景为最低优先级
                    noGroupService.push(host);
                }
                else {
                    if (runInSingleJarMode) {
                        havePriorityList.push(host);
                    }
                    else {
                        thirdPriorityList.push(host);
                    }
                }
            }
            else {
                if (!group) {
                    if (runInSingleJarMode) {
                        havePriorityList.push(host);
                    }
                    else {
                        thirdPriorityList.push(host);
                    }
                }
                else {
                    noGroupService.push(host);
                }
            }
        }
        highestPriorityList = utils_1.jj(highestPriorityList, pool);
        havePriorityList = utils_1.jj(havePriorityList, pool);
        thirdPriorityList = utils_1.jj(thirdPriorityList, pool);
        var tmpPool = [];
        if (highestPriorityList.length > 0) {
            // 如果完全匹配
            return this.getRandomHost(highestPriorityList);
        }
        else if (havePriorityList.length > 0) {
            // 存在优先级高的
            return this.getRandomHost(havePriorityList);
        }
        else if (thirdPriorityList.length > 0) {
            return this.getRandomHost(thirdPriorityList);
        }
        else {
            // 同网段的优先
            // @ts-ignore
            var cidr = address.interface().cidr;
            var block = new Netmask(cidr);
            pool.map(function (v) {
                if (block.contains(v.split('http://')[1])) {
                    tmpPool.push(v);
                }
            });
            if (tmpPool.length === 0) { // 如果不存在同网段，随便
                tmpPool = pool;
            }
            return this.getRandomHost(tmpPool);
        }
    };
    /**
     * 筛选混合云符合条件IP
     * http://cf.dui88.com/pages/viewpage.action?pageId=38788463
     * @param {EurekaClient.EurekaInstanceConfig[]} instances 服务实例
     * @param {*} pool  ip池
     * @returns
     * @memberof Pool
     */
    Pool.prototype.filterHybridCloud = function (instances, pool) {
        var currentApplicationZone = 'defaultZone';
        var aliyunCloud = [];
        var huaweiCloud = [];
        for (var i = 0; i < instances.length; i++) {
            var ins = instances[i];
            var hostName = ins.hostName, metadata = ins.metadata;
            var host = "http://" + hostName + ":" + ins.port.$;
            var zone = metadata.zone;
            if (hostName === ip) {
                currentApplicationZone = zone === 'huawei' ? 'huawei' : 'defaultZone';
            }
            // 阿里云机器环注册的metadata为zone=defaultZone，华为云注册的metadata为huawei (假如获取ZONE为空，则视为defaultZone，注册到eureka的zone值也为defaultZone)
            if (zone === 'huawei') {
                huaweiCloud.push(host);
            }
            else {
                aliyunCloud.push(host);
            }
        }
        aliyunCloud = utils_1.jj(aliyunCloud, pool);
        huaweiCloud = utils_1.jj(huaweiCloud, pool);
        var aliyunCloudLength = aliyunCloud.length;
        var huaweiCloudLength = huaweiCloud.length;
        // 如果任一机房没有实例，则去另一个机房随机获取实例
        if (aliyunCloudLength === 0) {
            return this.getRandomHost(huaweiCloud);
        }
        else if (huaweiCloudLength === 0) {
            return this.getRandomHost(aliyunCloud);
        }
        var _a = __read([aliyunCloudLength, huaweiCloudLength].sort(function (a, b) { return a - b; }), 2), min = _a[0], max = _a[1];
        // 判断服务在两个机房的分布是不是小于3，小于3做同机房优先调用，否则随机调用
        if (max / min < 3) {
            if (currentApplicationZone === 'huawei') {
                return this.getRandomHost(huaweiCloud);
            }
            else {
                return this.getRandomHost(aliyunCloud);
            }
        }
        else {
            return this.getRandomHost(__spread(aliyunCloud, huaweiCloud));
        }
    };
    return Pool;
}());
exports.default = Pool;
//# sourceMappingURL=pool.js.map