import { Eureka, EurekaClient } from 'eureka-js-client';
export interface IEurekaObjs {
    [name: string]: string[];
}
export default class Pool {
    private eurekaObjs;
    private instances;
    constructor(eureka: Eureka, services: string[]);
    /**
     * 遍历eureka
     * @param {Eureka} eureka  Eureka
     * @param {string[]} services 服务名
     */
    private getEurekas;
    private filterPool;
    /**
     * 获取所有eureka
     */
    getAllEurekas(): EurekaClient.EurekaInstanceConfig[];
    /**
     * 获取所有实例下的host
     */
    getAllHostName(): IEurekaObjs;
    private getRandomHost;
    getHost(name: string | number, localIp: string, filterGroup?: string): string;
    /**
     * 筛选混合云符合条件IP
     * http://cf.dui88.com/pages/viewpage.action?pageId=38788463
     * @param {EurekaClient.EurekaInstanceConfig[]} instances 服务实例
     * @param {*} pool  ip池
     * @returns
     * @memberof Pool
     */
    filterHybridCloud(instances: EurekaClient.EurekaInstanceConfig[], pool: any): string;
}
