"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var address = require("address");
var client_1 = require("./client");
var pool_1 = require("./pool");
var utils_1 = require("./utils");
var NODE_ENV = process.env.NODE_ENV || 'dev';
var Eurekaclient = /** @class */ (function () {
    function Eurekaclient(options) {
        options.services.push(options.appName);
        this.opts = options;
        this.eureka = client_1.default(options);
        this.pool = new pool_1.default(this.eureka, this.opts.services);
    }
    /**
     * 启动eureka
     * @returns Promise<Eureka>
     */
    Eurekaclient.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, opts, eureka;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this, opts = _a.opts, eureka = _a.eureka;
                        if (NODE_ENV)
                            eureka.start();
                        return [4 /*yield*/, utils_1.sleep(5000)
                            // 如果是生产环境,开启服务掉线校验
                        ];
                    case 1:
                        _b.sent();
                        // 如果是生产环境,开启服务掉线校验
                        this.checkServiceHasNeedRegistry(opts.appName);
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * stop
     */
    Eurekaclient.prototype.stop = function () {
        this.eureka.stop();
    };
    /**
     * 获取指定应用的ip
     * @param {(string | number)} name 应用名
     * @param {(string)} localIp 客户端IP
     * @param {string} [filterGroup] 要过滤的group service
     */
    Eurekaclient.prototype.getHost = function (name, localIp, filterGroup) {
        if (!NODE_ENV) {
            var ip = address.ip();
            return "http://" + ip + ":" + this.opts.port;
        }
        return this.pool.getHost(name, localIp, filterGroup);
    };
    /** 获取代理信息(客户端IP, serviceGroupKey) */
    Eurekaclient.prototype.getProxyInfoFromReq = function (req) {
        var name = '_duibaServiceGroupKey';
        var reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
        // 获取多场景的cookie
        var arr = [];
        var serviceGroupKey = '';
        if (req.headers.cookie && (arr = req.headers.cookie.match(reg))) {
            serviceGroupKey = unescape(arr[2]);
        }
        // 获取客户端ip地址
        var ip = req.headers['x-real-ip'] || req.headers['x-forwarded-for'] || req.connection.remoteAddres || req.socket.remoteAddress || '';
        if (ip.indexOf('::ffff:') !== -1) {
            ip = ip.substring(7);
        }
        return { ip: ip, serviceGroupKey: serviceGroupKey };
    };
    /**
     * 获取所有eureka
     */
    Eurekaclient.prototype.getAllEurekas = function () {
        return this.pool.getAllEurekas();
    };
    /**
     * 获取所有实例下的host
     */
    Eurekaclient.prototype.getAllHostName = function () {
        return this.pool.getAllHostName();
    };
    /**
     * 检查eureka服务是否掉线，掉线则重新注册服务
     * @param {string} appName
     * @memberof Eurekaclient
     */
    Eurekaclient.prototype.checkServiceHasNeedRegistry = function (appName) {
        var _this = this;
        var timer = null;
        // 服务开始注册后1分钟启动监听，每隔10s检查该服务是否不存在，如不存在重新注册
        timer = setInterval(function () { return __awaiter(_this, void 0, void 0, function () {
            var instances;
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, this.eureka.getInstancesByAppId(appName)];
                    case 1:
                        instances = _c.sent();
                        if (!((instances === null || instances === void 0 ? void 0 : instances.length) === 0)) return [3 /*break*/, 4];
                        console.log('服务出错');
                        (_a = global['Log']) === null || _a === void 0 ? void 0 : _a.error("eureka", appName + " \u670D\u52A1\u6389\u7EBF");
                        clearInterval(timer);
                        return [4 /*yield*/, this.eureka.start()];
                    case 2:
                        _c.sent();
                        (_b = global['Log']) === null || _b === void 0 ? void 0 : _b.error("eureka", appName + " \u91CD\u65B0\u6CE8\u518C");
                        return [4 /*yield*/, utils_1.sleep(10000)];
                    case 3:
                        _c.sent();
                        this.checkServiceHasNeedRegistry(appName);
                        _c.label = 4;
                    case 4: return [2 /*return*/];
                }
            });
        }); }, 10000);
    };
    return Eurekaclient;
}());
exports.default = Eurekaclient;
//# sourceMappingURL=index.js.map