<p align="center">
<img src="https://i.imgur.com/LnPvZvO.png" alt="ADPlayer" width="100">
</p>
<h1 align="center">DPlayer</h1>

> 🍭 Wow, such a lovely HTML5 danmaku video player

[![npm](https://img.shields.io/npm/v/dplayer.svg?style=flat-square)](https://www.npmjs.com/package/dplayer)
[![npm](https://img.shields.io/npm/l/dplayer.svg?style=flat-square)](https://github.com/MoePlayer/DPlayer/blob/master/LICENSE)
[![npm](https://img.shields.io/npm/dt/dplayer.svg?style=flat-square)](https://www.npmjs.com/package/dplayer)
[![size](https://badge-size.herokuapp.com/MoePlayer/DPlayer/master/dist/DPlayer.min.js?compression=gzip&style=flat-square)](https://github.com/MoePlayer/DPlayer/tree/master/dist)

## Introduction

![image](http://i.imgur.com/207ch36.jpg)

DPlayer is a lovely HTML5 danmaku video player to help people build video and danmaku easily.

**DPlayer supports:**

-   Streaming formats
    -   [HLS](https://github.com/video-dev/hls.js)
    -   [FLV](https://github.com/Bilibili/flv.js)
    -   [MPEG DASH](https://github.com/Dash-Industry-Forum/dash.js)
    -   [WebTorrent](https://github.com/webtorrent/webtorrent)
    -   Any other custom streaming formats
-   Media formats
    -   MP4 H.264
    -   WebM
    -   Ogg Theora Vorbis
-   Features
    -   Danmaku
    -   Screenshot
    -   Hotkeys
    -   Quality switching
    -   Thumbnails
    -   Subtitle

Using DPlayer on your project? [Let me know!](https://github.com/DIYgod/DPlayer/issues/31)

**[Docs](https://dplayer.diygod.dev/)**

**[中文文档](https://dplayer.diygod.dev/zh/)**

## Thanks

### Sponsors

<div>
<a href="https://www.dogecloud.com/?ref=dplayer" target="_blank">
    <img height="60px" src="https://player.dogecloud.com/img/logo_with_product3.png">
</a>
</div>

### Contributors

<a href="https://github.com/MoePlayer/DPlayer/graphs/contributors"><img src="https://opencollective.com/DPlayer/contributors.svg?width=890" /></a>

## Related Projects

Feel free to submit yours in [`Let me know!`](https://github.com/MoePlayer/DPlayer/issues/31)

### Tooling

-   [DPlayer-thumbnails](https://github.com/MoePlayer/DPlayer-thumbnails): generate video thumbnails

### Danmaku api

-   [DPlayer-node](https://github.com/MoePlayer/DPlayer-node): Node.js
-   [laravel-danmaku](https://github.com/MoePlayer/laravel-danmaku): PHP
-   [dplayer-live-backend](https://github.com/Izumi-kun/dplayer-live-backend): Node.js, WebSocket live backend
-   [RailsGun](https://github.com/MoePlayer/RailsGun): Ruby

### Plugins

-   [DPlayer-for-typecho](https://github.com/volio/DPlayer-for-typecho): Typecho
-   [Hexo-tag-dplayer](https://github.com/NextMoe/hexo-tag-dplayer): Hexo
-   [DPlayer_for_Z-BlogPHP](https://github.com/fghrsh/DPlayer_for_Z-BlogPHP): Z-BlogPHP
-   [DPlayer for Discuz!](https://coding.net/u/Click_04/p/video/git): Discuz!
-   [DPlayer for WordPress](https://github.com/BlueCocoa/DPlayer-WordPress): WordPress
-   [DPlayerHandle](https://github.com/kn007/DPlayerHandle): WordPress
-   [Selection](https://github.com/GreatSatan79/Selection): WordPress
-   [Vue-DPlayer](https://github.com/sinchang/vue-dplayer): Vue
-   [react-dplayer](https://github.com/hnsylitao/react-dplayer): React

### Other

-   [DPlayer-Lite](https://github.com/kn007/DPlayer-Lite): lite version
-   [hlsjs-p2p-engine](https://github.com/cdnbye/hlsjs-p2p-engine): Let your viewers become your unlimitedly scalable CDN
-   [CBPlayer](https://github.com/cdnbye/CBPlayer): Dplayer with CDNBye P2P plugin built in, supporting HLS, MP4 and MPEG-DASH P2P streaming.
-   Feel free to submit yours in [`Let me know!`](https://github.com/MoePlayer/DPlayer/issues/31)

## Who use DPlayer?

-   [学习强国](https://itunes.apple.com/cn/app/%E5%AD%A6%E4%B9%A0%E5%BC%BA%E5%9B%BD/id1426355645?mt=8): “学习强国”学习平台精心打造的手机客户端
-   [小红书](https://www.xiaohongshu.com/): 中国最大的生活社区分享平台，同时也是发现全球好物的电商平台
-   [极客时间](https://time.geekbang.org/): 极客邦科技出品的一款 IT 内容知识服务 App
-   [嘀哩嘀哩](http://www.dilidili.wang/): 兴趣使然的无名小站（D 站）
-   [银色子弹](https://www.sbsub.com/): 银色子弹，简称银弹，由多数柯南热爱者聚集在一起的组织
-   [浙江大学 CC98 论坛](https://zh.wikipedia.org/wiki/CC98%E8%AE%BA%E5%9D%9B): 浙江大学校网内规模最大的论坛，中国各大学中较活跃的 BBS 之一
-   [纸飞机南航青年网络社区](http://my.nuaa.edu.cn/video-video.html): 南京航空航天大学门户网站
-   [otomads](https://otomads.com/): 专注于音 MAD 的视频弹幕网站
-   [Cloudreve](https://github.com/HFO4/Cloudreve): 基于 ThinkPHP 构建的网盘系统
-   [oneindex](https://github.com/donwa/oneindex): Onedrive Directory Index
-   [arozos](https://github.com/tobychui/arozos): General purposed Web Desktop Operating Platform / OS for Raspberry Pis
-   [新东方云教室](https://roombox.xdf.cn/)
-   [BBHouse](https://github.com/endcloud/bbhouse-tauri): A Bilibili Cross-Platform Desktop Client Powered By Tauri
-   [Tampermonkey 阿里云盘](https://greasyfork.org/zh-CN/scripts/425955-%E9%98%BF%E9%87%8C%E4%BA%91%E7%9B%98)
-   Feel free to submit yours in [`Let me know!`](https://github.com/MoePlayer/DPlayer/issues/31)

## Donate

DPlayer is an MIT licensed open source project and completely free to use. However, the amount of effort needed to maintain and develop new features for the project is not sustainable without proper financial backing.

You can support DPlayer via donations.

### Recurring Donation

-   Become a Sponser on [GitHub](https://github.com/sponsors/DIYgod)
-   Become a Sponser on [Patreon](https://www.patreon.com/DIYgod)
-   Become a Sponser on [爱发电](https://afdian.net/@diygod)
-   Contact us directly: i@diygod.me

### One-time Donation

We accept donations via the following ways:

-   [WeChat Pay](https://diygod.me/images/wx.jpg)
-   [Alipay](https://diygod.me/images/zfb.jpg)
-   [Paypal](https://www.paypal.me/DIYgod)

## Author

**DPlayer** © [DIYgod](https://github.com/DIYgod), Released under the [MIT](./LICENSE) License.<br>
Authored and maintained by DIYgod with help from contributors ([list](https://github.com/DIYgod/DPlayer/contributors)).

> [Blog](https://diygod.me) · GitHub [@DIYgod](https://github.com/DIYgod) · Twitter [@DIYgod](https://twitter.com/DIYgod) · Telegram Channel [@awesomeDIYgod](https://t.me/awesomeDIYgod)
