const config = require('../config');

module.exports = {
  registerRoute: function() {
    this.options.app.router.all(config.checkUrl, (ctx, next) => {
      if (this.serverStatus === 'SHUTDOWN') {
        ctx.status = 503;
        ctx.body = 'INVALID';
      } else {
        ctx.body = 'OK';
      }
    });
    this.options.app.router.all(config.stopUrl, (ctx, next) => {
      const host = ctx.request.header.host;
      if (host.split(':')[0] !== '127.0.0.1') {
        ctx.body = 'NO PERMISSION';
      } else {
        ctx.body = 'SHUTDOWN';
        this.stopServer();
      }
    });
  }
}