# Node-docker
node工程接入docker，兼容express, koa, egg

## Installation
``` bash
yarn add @tuia/node-docker
```

## Usage
``` js
// Express
const express = require('express');
const NodeDocker = require('@tuia/node-docker');

const app = express();

const dockerApp = new NodeDocker({
  app,
  appType: 'express',
  port: 3000
});

app.get('/', (req, res) => {
  res.send('Hello Express')
})

dockerApp.startServer();

// Egg

const Application = require('egg').Application;
const NodeDocker = require('@tuia/node-docker');

const app = new Application();

const dockerApp = new NodeDocker({
  app,
  appType: 'egg',
  port: 3000
});

app.router.get('/', (ctx) => {
  ctx.body = 'Hello Egg';
})

dockerApp.startServer();

// koa
const koa = require('koa');
const NodeDocker = require('@tuia/node-docker');

const app = new koa();

const dockerApp = new NodeDocker({
  app,
  appType: 'koa',
  port: 3000
});

app.use(async(ctx)=>{
  const url = ctx.request.url;
  if (url === '/') {
    ctx.body = 'Hello Koa';
  }
})

dockerApp.startServer();
```

## Options
* app: 应用实例，支持express,koa,egg
* appType: 指定应用实例类型
* port: 应用端口号