"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEventName = void 0;
/**
 * @ignore
 * get view event name, with name:event
 * @param type original event type
 * @param name event trigger shape name
 * @returns the name:event string
 */
function getEventName(type, name) {
    if (type.includes(':')) {
        return type;
    }
    return name ? "".concat(name, ":").concat(type) : type;
}
exports.getEventName = getEventName;
//# sourceMappingURL=event.js.map