// 统一请求路径前缀在libs/axios.js中修改
import {
  getRequest,
  postRequest,
  putRequest,
  deleteRequest,
  importRequest,
  getRequestWithNoToken,
  putRequestWithNoForm,
  postRequestWithNoTokenData,
  postRequestWithNoForm,
  managerUrl
} from "@/libs/axios";

let commonUrl = (process.env.NODE_ENV === 'development' ? BASE.API_DEV.common : BASE.API_PROD.common)

// 文件上传接口
export const uploadFile = commonUrl+ "/common/common/upload/file";

// 通知提示信息
export const getNoticePage = (params) => {
  return getRequest("/statistics/index/notice", params);
};

// 登陆
export const login = (params) => {
  return postRequestWithNoTokenData("/passport/user/login", params);
};

// 登出
export const logout = () => {
  return postRequest("/passport/user/logout");
};

// 刷新token
export const handleRefreshToken = (token) => {
  return getRequestWithNoToken(`/passport/user/refresh/${token}`);
};
// 获取用户登录信息
export const userInfo = (params) => {
  return getRequest("/passport/user/info", params);
};

// 个人中心编辑
export const userInfoEdit = (params) => {
  return putRequest("/passport/user/edit", params);
};
// 个人中心修改密码
export const changePass = (params) => {
  return putRequest("/passport/user/editPassword", params);
};
// 获取用户数据 多条件
export const getUserListData = (params) => {
  return getRequest("/passport/user", params);
};

// 添加用户
export const addUser = (params) => {
  return postRequest("/passport/user", params);
};
// 编辑用户
export const editOtherUser = (params) => {
  return putRequest("/passport/user/admin/edit", params);
};
// 启用用户
export const enableUser = (id, params) => {
  return putRequest(`/passport/user/enable/${id}`, params);
};
// 删除用户
export const deleteUser = (ids, params) => {
  return deleteRequest(`/passport/user/${ids}`, params);
};
/****************************** 部门 */
// 通过部门获取全部角色数据
export const getUserByDepartmentId = (id, params) => {
  return getRequest(`/permission/departmentRole/${id}`, params);
};

// 通过部门修改绑定角色
export const updateDepartmentRole = (id, params) => {
  return putRequestWithNoForm(`/permission/departmentRole/${id}`, params);
};

// 获取一级部门
export const initDepartment = (params) => {
  return getRequest("/permission/department", params);
};
// 加载部门子级数据
export const loadDepartment = (id) => {
  return getRequest(`/permission/department/${id}`);
};
// 添加部门
export const addDepartment = (params) => {
  return postRequest("/permission/department", params);
};
// 编辑部门
export const editDepartment = (ids, params) => {
  return putRequest(`/permission/department/${ids} `, params);
};
// 删除部门
export const deleteDepartment = (ids, params) => {
  return deleteRequest(`/permission/department/${ids}`, params);
};
// 搜索部门
export const searchDepartment = (params) => {
  return getRequest("/permission/department", params);
};

/****************************** 部门结束 */

// 获取全部角色数据
export const getAllRoleList = (params) => {
  return getRequest("/permission/role", params);
};
// 分页获取角色数据
export const getRoleList = (params) => {
  return getRequest("/permission/role", params);
};

// 添加角色
export const addRole = (params) => {
  return postRequest("/permission/role", params);
};

// 编辑角色
export const editRole = (params) => {
  return putRequest(`/permission/role/${params.roleId}`, params);
};

// 查看某角色拥有的菜单
export const selectRoleMenu = (params) => {
  return getRequest(`/permission/roleMenu/${params}`);
};

// 保存角色菜单
export const saveRoleMenu = (id, params) => {
  return postRequestWithNoForm(`/permission/roleMenu/${id}`, params);
};

// 分配角色权限
export const editRolePerm = (params) => {
  return postRequest("/permission/role/editRolePerm", params);
};
// 分配角色数据权限
export const editRoleDep = (params) => {
  return postRequest("/permission/role/editRoleDep", params);
};
// 删除角色
export const deleteRole = (ids, params) => {
  return deleteRequest(`/permission/role/${ids}`, params);
};

/****************************** 角色结束 */


/****************************** 权限 */
// 获取全部权限数据
export const getAllPermissionList = (params) => {
  return getRequest("/permission/menu/tree", params);
};

// 获取全部权限数据
export const getCurrentPermissionList = (params) => {
  return getRequest("/permission/menu/memberMenu", params);
};

// 添加权限
export const addPermission = (params) => {
  return postRequest("/permission/menu", params);
};

// 编辑权限
export const editPermission = (params) => {
  return putRequest(`/permission/menu/${params.id}`, params);
};
// 删除权限
export const deletePermission = (ids, params) => {
  return deleteRequest(`/permission/menu/${ids}`, params);
};
// 搜索权限
export const searchPermission = (params) => {
  return getRequest("/permission/menu", params);
};

/****************************** 权限结束 */
// 分页获取文件数据
export const getFileListData = (params) => {
  return getRequest("/common/file", params);
};

// 重命名文件
export const renameFile = (params) => {
  return postRequest("/common/file/rename", params);
};
// 删除文件
export const deleteFile = (ids, params) => {
  return deleteRequest(`/common/file/delete/${ids}`, params);
};
// 下载文件
export const aliDownloadFile = (fKey, params) => {
  return getRequest(`/file/ali/download/${fKey}`, params);
};

// base64上传
export const base64Upload = (params) => {
  return postRequest("/common/common/upload/file", params);
};

// 重置用户密码
export const resetPassword = (params) => {
  return postRequest(`/passport/user/resetPassword/${params}`);
};


