// 统一请求路径前缀在libs/axios.js中修改
import {
  getRequest,
  postRequest,
  putRequest,
  deleteRequest,
  postRequestWithNoForm,
  sellerUrl,
  wxUrl
} from '@/libs/axios';


//  交由商家申诉
export const storeComplain = (params) => {
  return putRequest(`/order/complain/status`, params)
}

export const addAfterSale = (params) => {
  return postRequestWithNoForm(`/order/afterSale/apply`, params)
}


//  获取售后原因分页列表
export const getAfterSaleReasonPage = (params) => {
  return getRequest('/order/afterSaleReason/getByPage', params)
}

//  删除售后原因
export const delAfterSaleReason = (id) => {
  return deleteRequest(`/order/afterSaleReason/delByIds/${id}`)
}

//  添加售后原因
export const addAfterSaleReason = (params) => {
  return postRequest(`/order/afterSaleReason`, params)
}

//  修改售后原因
export const editAfterSaleReason = (id, params) => {
  return putRequest(`/order/afterSaleReason/update/${id}`, params)
}

// 售后服务单详情
export const afterSaleOrderDetail = (sn) => {
  return getRequest(`/order/afterSale/${sn}`)
}

// 商家审核
export const afterSaleSellerReview = (sn, params) => {
  return putRequest(`/order/afterSale/review/${sn}`, params)
}

// 商家确认收货
export const afterSaleSellerConfirm = (sn, params) => {
  return putRequest(`${sellerUrl}/order/afterSale/confirm/${sn}`, params)
}

// 商家换货业务发货
export const afterSaleSellerDelivery = (sn, params) => {
  return putRequest(`/order/afterSale/${sn}/delivery`, params)
}

//  获取交易投诉信息
export const getOrderComplain = (params) => {
  return getRequest('/order/complain', params)
}

//  获取交易投诉详细信息
export const getOrderComplainDetail = (id) => {
  return getRequest(`/order/complain/${id}`)
}

//  交易投诉对话
export const addOrderCommunication = (params) => {
  return postRequest(`/order/complain/communication`, params)
}

//  平台仲裁
export const orderComplete = (id, params) => {
  return putRequest(`/order/complain/complete/${id}`, params)
}
// 上传待发货的订单列表
export const uploadDeliverExcel = params => {
  return postRequestWithNoForm(`${sellerUrl}/order/order/batchDeliver`, params );
};
// 下载待发货的订单列表
export const downLoadDeliverExcel = params => {
  return getRequest(`${sellerUrl}/order/order/downLoadDeliverExcel`, params, 'blob');
};
// 修改物流
export const deliveryMod = (sn,params) => {
  return getRequest(`${sellerUrl}/order/order/${sn}/delivery`, params);
};
export const aggEs = (params) => {
  return postRequestWithNoForm(`/order/order/agg/es`, params);
};

export const exportOrderExcel = params => {
  return postRequestWithNoForm(`/order/order/queryExportOrder/es`, params,'blob');
};
// 获取发货记录接口
export const getDeliveryRecord = (params) => {
  return getRequest(`/order/order/delivery/record`, params)
}
// 修改备注
export const remarkMod = (sn,remark) => {
  return getRequest(`/order/order/remark/${sn}?orderSn=${sn}&remark=${remark}`);
};
// 修改备注
export const remarkBathMod = (params) => {
  return postRequestWithNoForm(`/order/order/remark/batch`,params);
};

//  查询订单列表
export const getOrderList = (params) => {
  return postRequestWithNoForm(`/order/order/es`, params)
}

//  订单付款
export const orderPay = (sn) => {
  return postRequest(`/order/order/${sn}/pay`)
}

//  订单付款
export const orderDetail = (sn) => {
  return getRequest(`/order/order/${sn}`)
}

//  修改订单价格
export const updateOrderPrice = (sn, params) => {
  return putRequest(`/order/order/update/${sn}/price`, params)
}

// 获取订单日志
export const getOrderLog = (params) => {
  return getRequest(`/orderLog/getByPage`, params)
}

// 订单取消
export const orderCancel = (sn, params) => {
  return postRequest(`/order/order/${sn}/cancel`, params)
}

// 修改收货地址
export const editOrderConsignee = (sn, params) => {
  return postRequest(`/order/order/update/${sn}/consignee`, params)
}

//  获取售后订单列表
export const getAfterSaleOrderPage = (params) => {
  return getRequest('/order/afterSale/page', params)
}

//  获取售后订单详情
export const getAfterSaleOrderDetail = (sn) => {
  return getRequest(`/order/afterSale/get/${sn}`)
}
//售后单查询物流
export const getAfterSaleTraces = (sn) => {
  return getRequest(`/order/afterSale/getDeliveryTraces/${sn}`)
}
// 获取商家选中的物流公司
export const getLogisticsChecked = () => {
  return getRequest(`/other/logistics/getChecked`)
}

export const deliveryAddAndMod = (params) => {
  return postRequestWithNoForm(`/order/afterSale/delivery`,params);
};

export const getAfterSaleLog = (sn) => {
  return getRequest(`/order/afterSale/get/getAfterSaleLog/${sn}`);
};

export const auditSale = (params) => {
  return postRequestWithNoForm(`/order/afterSale/audit`,params);
};

export const auditDeliverySale = (params) => {
  return postRequestWithNoForm(`/order/afterSale/delivery/audit`,params);
};


//查询物流
export const getTraces = (sn, params) => {
  return postRequest(`/order/order/getTraces/${sn}`, params)
}
//获取发票列表
export const getReceiptPage = (params) => {
  return getRequest(`/trade/receipt`, params)
}
//平台退款
export const refundPrice = (afterSaleSn, params) => {
  return putRequest(`/order/afterSale/refund/${afterSaleSn}`, params)
}


//平台收款记录
export const paymentLog = (params) => {
  return getRequest(`/payment/paymentLog`, params)
}
//付款单对账
export const paymentReconciliation= (params) => {
  return putRequest(`/payment/paymentLog`, params)
}

//平台退款记录
export const refundLog = (params) => {
  return getRequest(`/payment/refundLog`, params)
}
//退款单对账
export const refundReconciliation = (params) => {
  return putRequest(`/payment/refundLog`, params)
}

//售后单商家收货信息
export const storeAddress = (sn) => {
  return getRequest(`/order/afterSale/getStoreAfterSaleAddress/${sn}`)
}

//获取分账记录分页
export const withdrawLog = (params) => {
  return getRequest(`/payment/withdrawLog`, params);
};

//获取提现记录分页
export const outOrderLog = (params) => {
  return getRequest(`/payment/outOrderLog`, params);
};
//通过分账单号获取分账详情列表
export const detailLog = (outOrderNo) => {
  return getRequest(`/payment/outOrderLog/getDetailLog/${outOrderNo}`);
};
//获取微信账单接口分页
export const wechatBill = (params) => {
  return getRequest(`/payment/wechatBill`, params);
};
//通过id获取微信账单接口
export const detailWechatBill= (id) => {
  return getRequest(`/payment/wechatBill/get/${id}`);
};


// 商家查询投诉列表
export const complaintList = (params) => {
  return getRequest(`${sellerUrl}/complaint/list`, params);
};
export const complainCount = (params) => {
  return getRequest(`${sellerUrl}/complaint/getCount`, params);
};
export const complaintWXList = (params) => {
  return getRequest(`${wxUrl}/complaint/list`, params);
};
export const complaintGetWXCount = (params) => {
  return getRequest(`${wxUrl}/complaint/getCount`, params);
};



export const complaintReview = (params) => {
  return postRequestWithNoForm(`${sellerUrl}/complaint/review`, params);
};

export const complaintDetail = (id) => {
  return  getRequest(`${sellerUrl}/complaint/detail?id=${id}`);
};



