/*
 * @Author: 周成
 * @Date: 2018-01-24 14:32:14
 * @Last Modified by: 周成
 * @Last Modified time: 2020-03-17 16:33:09
 */

const fs = require('fs');
const path = require('path');

const OSS = require('ali-oss');

const chalk = require('chalk');
const ProgressBar = require('progress');

const NODE_ENV = process.env.NODE_ENV;
const isLocal = NODE_ENV === 'local' || NODE_ENV === 'development' || NODE_ENV === 'dev' || NODE_ENV === 'autotest';

class TuiaAutoUpload {
  constructor(props) {
    const defaultOptions = {
      dir: undefined,
      originDir: undefined,
      bucket: 'duiba',
      internal: undefined
    }
    this.options = Object.assign({}, defaultOptions, props);
    if (!this.options.dir || !this.options.originDir) {
      console.log(chalk.red('缺少参数，初始化失败'))
      return;
    }
    return this.init();
  }
  init() {
    const OSSOptions = {
      region: 'oss-cn-hangzhou',
      accessKeyId: 'LTAI5tPUSSxgkEmKPAfVXUQQ',
      accessKeySecret: '6sk3EDd1BYrXlAUoh8maMuN7hOMkh1',
      bucket: this.options.bucket
    }
    const client = new OSS(OSSOptions);

    const startTime = new Date() * 1;

    this.bar = new ProgressBar(chalk.yellow(`  文件上传中 [:bar] :current/${this.files().length} :percent :elapseds`), {
      complete: '●',
      incomplete: '○',
      width: 20,
      total: this.files().length,
      callback: () => {
        console.log(chalk.green('\n  All complete.'));
        console.log(chalk.blue(`\n  本次队列文件共${this.files().length}个，已存在文件${this.existFiles}个，上传文件${this.uploadFiles}个，消耗时间：${parseFloat((new Date() * 1 - startTime) / 1000)} s\n`));
      }
    })
    return new Promise(resolve => {
      if (this.options.internal !== undefined) {
        this.client = new OSS({
          ...OSSOptions,
          internal: this.options.internal
        });
        resolve(this)
      } else if (isLocal) {
        this.client = new OSS({
          ...OSSOptions,
          internal: false
        });
        resolve(this)
      } else {
        client.getBucketInfo(this.options.bucket).then((result) => {
          this.client = new OSS({
            ...OSSOptions,
            internal: result.bucket.Location.match(/internal/) ? true : false
          });
          resolve(this)
        }).catch(err => {
          this.client = new OSS({
            ...OSSOptions,
            internal: false
          });
          resolve(this)
        });
      }
    });
  }
  readDirSync(dir) {
    const files = [];
    function loop(childrenDir) {
      const allFiles = fs.readdirSync(childrenDir);
      allFiles.forEach((ele, index) => {
        const info = fs.statSync(`${childrenDir}/${ele}`);
        if (info.isDirectory()) {
          loop(`${childrenDir}/${ele}`);
        } else {
          files.push(path.join(childrenDir, ele));
        }
      });
    }
    loop(dir);
    return files;
  }
  files() {
    return this.readDirSync(this.options.dir);
  }
  async start() {
    const files = this.files();

    this.existFiles = 0;
    this.uploadFiles = 0;
    this.errorFiles = 0;

    for (let index = 0; index < files.length; index++) {
      const file = files[index];
      const originPath = path.join(this.options.originDir, file.replace(this.options.dir, '')).replace(/\\/g, '/');

      let originFile;

      try {
        originFile = await this.client.head(originPath);
      } catch (error) {
        originFile = error;
      }
      if (this.options.bucket === 'daily-duiba') {
        try {
          await this.client.put(originPath, file, {
            headers: {
              'Cache-Control': 'no-cache'
            }
          });        
          this.uploadFiles += 1;
        } catch (error) {
          console.error(error);
          process.exit(1);
        }
      } else {
        if (originFile.status === 404) {
          try {
            await this.client.put(originPath, file);        
            this.uploadFiles += 1;
          } catch (error) {
            console.error(error);
            process.exit(1);
          }
        } else {
          this.existFiles += 1;
        }
      }
      
      this.bar.tick();
    }
  }
}

module.exports = TuiaAutoUpload;